/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class NetDestroyer
extends NetedItem {
    public NetDestroyer(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 100;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        super.use(level, player, usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        super.finishUsingItem(stack, level, livingEntity);
        if (!(livingEntity instanceof Player)) {
            return stack;
        }
        Player player = (Player)livingEntity;
        if (!level.isClientSide()) {
            if ((Integer)stack.getOrDefault(ModDataComponents.NET_ID_DATA, (Object)-1) >= 0) {
                DimensionsNet itemNet = DimensionsNet.getNetFromId((Integer)stack.getOrDefault(ModDataComponents.NET_ID_DATA, (Object)-1));
                if (itemNet != null) {
                    DimensionsNet playerNet = DimensionsNet.getNetFromPlayer(player);
                    if (playerNet != null && playerNet.getId() == itemNet.getId() && playerNet.isOwner(player)) {
                        playerNet.destroySelf();
                        stack.consume(1, (LivingEntity)player);
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item_net_destroyed"));
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.cant_delete_net"));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.error_item_net"));
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item_need_bound"));
            }
        }
        return stack;
    }

    @Override
    protected boolean validToReWrite(DimensionsNet net, Player player) {
        return net.isOwner(player);
    }
}

