/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataComponents.Custom.ItemStackContents;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenuTerminal;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetTerminalItem
extends NetedItem
implements MenuProvider {
    public static final Map<Player, MenuTriggerContext> contextMap = new WeakHashMap<Player, MenuTriggerContext>();

    public NetTerminalItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        super.use(level, player, usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!level.isClientSide()) {
            if (itemstack.get(ModDataComponents.CRAFT_SLOTS) == null) {
                itemstack.set(ModDataComponents.CRAFT_SLOTS, (Object)new ItemStackContents((NonNullList<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY)));
            }
            if ((Integer)itemstack.getOrDefault(ModDataComponents.NET_ID_DATA, (Object)-1) >= 0) {
                DimensionsNet net = DimensionsNet.getNetFromId((Integer)itemstack.getOrDefault(ModDataComponents.NET_ID_DATA, (Object)-1));
                if (net != null) {
                    contextMap.put(player, new MenuTriggerContext(usedHand, itemstack));
                    player.openMenu((MenuProvider)this);
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item_need_bound"));
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        MenuTriggerContext ctx = contextMap.remove(player);
        if (ctx == null) {
            ctx = new MenuTriggerContext(player.getUsedItemHand(), player.getItemInHand(player.getUsedItemHand()));
        }
        if (ctx.stack.getItem() != this || !ctx.stack.has(ModDataComponents.NET_ID_DATA)) {
            return null;
        }
        DimensionsNet net = DimensionsNet.getNetFromId((Integer)ctx.stack.getOrDefault(ModDataComponents.NET_ID_DATA, (Object)-1));
        if (net == null) {
            return null;
        }
        return new DimensionsCraftMenuTerminal(containerId, inventory, net.getUnifiedStorage(), ((ItemStackContents)ctx.stack.get(ModDataComponents.CRAFT_SLOTS)).contents(), ctx.stack, null);
    }

    public boolean shouldTriggerClientSideContainerClosingOnOpen() {
        return super.shouldTriggerClientSideContainerClosingOnOpen();
    }

    public static class MenuTriggerContext {
        public final InteractionHand hand;
        public final ItemStack stack;

        public MenuTriggerContext(InteractionHand hand, ItemStack stack) {
            this.hand = hand;
            this.stack = stack;
        }
    }
}

