/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.AbstractUnorderedStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.UnorderedStackHandlerKeepZero;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.UnorderedStackHandlerRemoveZero;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.Integration.JECharacters.PinInMatches;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.DisorderedSlotGroupSync;
import com.wintercogs.beyonddimensions.Menu.Slot.DisorderedStackTypedSlot;
import com.wintercogs.beyonddimensions.Unit.TinyPinyinUtils;
import com.wintercogs.beyonddimensions.Unit.TooltipHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DimensionsNetMenu
extends BDBaseMenu {
    public int maxLines = 6;
    public int lineData = 0;
    public int maxLineData = 0;
    private String searchText = "";
    public AbstractUnorderedStackHandler storage;
    public AbstractUnorderedStackHandler viewerStorage;
    private ArrayList<Integer> cacheIndex;
    public boolean hasShiftDown = false;
    protected int storageStartIndex;
    protected int storageEndIndex;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<DimensionsNetMenu>> Dimensions_Net_Menu = MENU_TYPES.register("dimensions_net_menu", () -> IMenuTypeExtension.create(DimensionsNetMenu::new));

    public DimensionsNetMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(Dimensions_Net_Menu.get(), id, playerInventory, new UnorderedStackHandlerRemoveZero(AbstractUnorderedStackHandler.UiTimestampPolicy.NONE));
    }

    public DimensionsNetMenu(MenuType<?> menuType, int id, Inventory playerInventory, AbstractUnorderedStackHandler data) {
        super(menuType, id, playerInventory);
        if (this.player.level().isClientSide()) {
            this.maxLines = Config.uiPageNum;
            this.searchText = Config.uiSearch;
        }
        this.storage = data;
        this.viewerStorage = new UnorderedStackHandlerKeepZero(AbstractUnorderedStackHandler.UiTimestampPolicy.NONE);
        this.addSlotGroupSync(new DisorderedSlotGroupSync(this, this.slotGroupSyncs.size(), this.storage){

            @Override
            public void afterLoadChange() {
                if (!DimensionsNetMenu.this.hasShiftDown) {
                    DimensionsNetMenu.this.updateViewerStorage();
                } else {
                    DimensionsNetMenu.this.updateOnlyCountAndNewViewer();
                }
                TooltipHelper.readAsCache(DimensionsNetMenu.this.storage.getStorage(), Item.TooltipContext.of((Level)DimensionsNetMenu.this.player.level()), DimensionsNetMenu.this.player, (TooltipFlag)TooltipFlag.Default.NORMAL);
                TooltipHelper.readAsCache(DimensionsNetMenu.this.storage.getStorage(), Item.TooltipContext.of((Level)DimensionsNetMenu.this.player.level()), DimensionsNetMenu.this.player, (TooltipFlag)TooltipFlag.Default.ADVANCED);
            }
        });
        this.addPlayerInv(playerInventory);
        this.addStorageSlots();
    }

    protected void addStorageSlots() {
        this.vanillaQuickMoveStartIndex = this.storageStartIndex = this.slots.size();
        if (this.player.level().isClientSide()) {
            for (int row = 0; row < 99; ++row) {
                for (int col = 0; col < 9; ++col) {
                    DisorderedStackTypedSlot newSlot = new DisorderedStackTypedSlot(this, this.viewerStorage, -1, this.inventoryStartIndex, this.inventoryEndIndex, 8 + col * 18, 25 + row * 18);
                    if (row >= this.getLines()) {
                        newSlot.setActive(false);
                    }
                    this.addSlot(newSlot);
                }
            }
        } else {
            for (int row = 0; row < 99; ++row) {
                for (int col = 0; col < 9; ++col) {
                    DisorderedStackTypedSlot newSlot = new DisorderedStackTypedSlot(this, this.storage, -1, this.inventoryStartIndex, this.inventoryEndIndex, 8 + col * 18, 25 + row * 18);
                    if (row >= this.getLines()) {
                        newSlot.setActive(false);
                    }
                    this.addSlot(newSlot);
                }
            }
        }
        this.vanillaQuickMoveEndIndex = this.storageEndIndex = this.slots.size();
    }

    protected void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    public void rebuildSlots() {
        int sSlotNum = 0;
        for (Slot slot : this.slots) {
            if (!(slot instanceof AbstractStackTypedSlot)) continue;
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            sSlot.setActive(sSlotNum / 9 < this.getLines());
            ++sSlotNum;
        }
        int slotNum = 0;
        for (int i = this.inventoryStartIndex; i < this.inventoryEndIndex; ++i) {
            Slot slot = (Slot)this.slots.get(i);
            slot.y = slotNum / 9 < 3 ? 25 + (this.getLines() - 1) * 18 + 26 + 6 + slotNum / 9 * 18 : 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4;
            ++slotNum;
        }
    }

    public int getLines() {
        return this.maxLines;
    }

    public void reduceLines() {
        --this.maxLines;
    }

    public void addLines() {
        ++this.maxLines;
    }

    public void setLines(int lines) {
        this.maxLines = lines;
    }

    public void updateViewerStorage() {
        this.viewerStorage.clearStorage();
        for (KeyAmount stack : this.storage.getStorage()) {
            this.viewerStorage.insert(stack.key(), stack.amount(), false);
        }
        this.buildIndexList(new ArrayList<KeyAmount>(this.viewerStorage.getStorage()), true);
    }

    public void updateOnlyCountAndNewViewer() {
        HashMap storageMap = new HashMap();
        for (KeyAmount stack : this.storage.getStorage()) {
            storageMap.put(stack.key(), stack.amount());
        }
        for (KeyAmount viewerStack : this.viewerStorage.getStorage()) {
            long amount = storageMap.getOrDefault(viewerStack.key(), 0L);
            this.viewerStorage.setAmountByKey(viewerStack.key(), amount);
        }
    }

    public void buildIndexList(ArrayList<KeyAmount> itemStorage, boolean needsUpdateCacheIndex) {
        if (!this.player.level().isClientSide()) {
            return;
        }
        if (needsUpdateCacheIndex || this.cacheIndex == null) {
            this.cacheIndex = this.buildStorageWithCurrentState(new ArrayList<KeyAmount>(itemStorage));
        }
        this.updateScrollLineData(this.cacheIndex.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.getLines() * 9; ++i) {
            if (i + this.lineData * 9 < this.cacheIndex.size()) {
                int index = this.cacheIndex.get(i + this.lineData * 9);
                indexList.add(index);
                continue;
            }
            indexList.add(-1);
        }
        this.loadIndexList(indexList);
    }

    public void loadIndexList(ArrayList<Integer> list) {
        int listIndex = 0;
        for (int slotIndex = this.storageStartIndex; listIndex < list.size() && slotIndex < this.storageEndIndex; ++listIndex, ++slotIndex) {
            ((AbstractStackTypedSlot)((Object)this.slots.get(slotIndex))).setTheSlotIndex(list.get(listIndex));
        }
    }

    public void loadSearchText(String text) {
        this.searchText = text.toLowerCase(Locale.ENGLISH);
    }

    public ArrayList<Integer> buildStorageWithCurrentState(ArrayList<KeyAmount> unifiedStorage) {
        boolean needModFilter;
        boolean needNameFilter;
        if (!this.player.level().isClientSide()) {
            return new ArrayList<Integer>();
        }
        String s = this.searchText == null ? "" : this.searchText.toLowerCase(Locale.ENGLISH);
        boolean hasSearch = !s.isEmpty();
        String[] parts = DimensionsNetMenu.splitSearch(s);
        String namePart = parts[0];
        String idPart = parts[1];
        String tipPart = parts[2];
        boolean hasSymbol = !idPart.isEmpty() || !tipPart.isEmpty();
        boolean bl = needNameFilter = hasSearch && !namePart.isEmpty();
        boolean bl2 = hasSearch && (hasSymbol ? !idPart.isEmpty() : !namePart.isEmpty()) ? true : (needModFilter = false);
        boolean needTooltipFilter = hasSearch && (hasSymbol ? !tipPart.isEmpty() : !namePart.isEmpty());
        ButtonState primaryState = Config.uiSortButton;
        ButtonState secondaryState = Config.uiSecondSortButton;
        if (primaryState == null) {
            primaryState = ButtonState.SORT_NAME;
        }
        boolean useSecondary = secondaryState != null && secondaryState != primaryState;
        boolean needNameSort = primaryState == ButtonState.SORT_NAME || useSecondary && secondaryState == ButtonState.SORT_NAME;
        boolean needModidSort = primaryState == ButtonState.SORT_MODID || useSecondary && secondaryState == ButtonState.SORT_MODID;
        boolean needQtySort = primaryState == ButtonState.SORT_QUANTITY || useSecondary && secondaryState == ButtonState.SORT_QUANTITY;
        boolean needCTimeSort = primaryState == ButtonState.SORT_INSERTED_TIME || useSecondary && secondaryState == ButtonState.SORT_INSERTED_TIME;
        boolean needMTimeSort = primaryState == ButtonState.SORT_MODIFIED_TIME || useSecondary && secondaryState == ButtonState.SORT_MODIFIED_TIME;
        Map<IStackKey<?>, Long> ctimeMap = needCTimeSort ? this.storage.getCreationTimeMap() : null;
        Map<IStackKey<?>, Long> mtimeMap = needMTimeSort ? this.storage.getLastModifiedTimeMap() : null;
        ArrayList<Row> rows = new ArrayList<Row>(unifiedStorage.size());
        for (int i = 0; i < unifiedStorage.size(); ++i) {
            boolean matched;
            KeyAmount ka = unifiedStorage.get(i);
            if (ka == null || ka.isEmpty()) continue;
            IStackKey<?> key = ka.key();
            String displayName = null;
            String modIdLower = null;
            String modIdSort = null;
            if (!hasSearch) {
                matched = true;
            } else if (hasSymbol) {
                matched = true;
                if (needNameFilter && !this.checkTextMatches(displayName = key.getRender().getDisplayName(key).getString(), namePart)) {
                    matched = false;
                }
                if (matched && !idPart.isEmpty() && !(modIdLower = key.getModId().toLowerCase(Locale.ENGLISH)).contains(idPart)) {
                    matched = false;
                }
                if (matched && !tipPart.isEmpty() && !this.checkTooltipMatches(ka, tipPart)) {
                    matched = false;
                }
            } else {
                boolean any = false;
                if (!namePart.isEmpty()) {
                    if (needNameFilter) {
                        displayName = key.getRender().getDisplayName(key).getString();
                        any |= this.checkTextMatches(displayName, namePart);
                    }
                    if (!any && needModFilter) {
                        modIdLower = key.getModId().toLowerCase(Locale.ENGLISH);
                        any |= modIdLower.contains(namePart);
                    }
                    if (!any && needTooltipFilter) {
                        any |= this.checkTooltipMatches(ka, namePart);
                    }
                }
                matched = any;
            }
            if (!matched) continue;
            if (needNameSort && displayName == null) {
                displayName = key.getRender().getDisplayName(key).getString();
            }
            if (needModidSort) {
                modIdSort = key.getModId();
            }
            long amt = needQtySort ? ka.amount() : 0L;
            long ctime = needCTimeSort && ctimeMap != null ? ctimeMap.getOrDefault(key, 0L) : 0L;
            long mtime = needMTimeSort && mtimeMap != null ? mtimeMap.getOrDefault(key, 0L) : 0L;
            rows.add(new Row(i, displayName, modIdSort, amt, ctime, mtime));
        }
        if (!rows.isEmpty()) {
            Comparator<Row> primary = this.buildRowComparator(primaryState);
            if (useSecondary) {
                Comparator<Row> secondary = this.buildRowComparator(secondaryState);
                rows.sort(primary.thenComparing(secondary));
            } else {
                rows.sort(primary);
            }
            if (Config.uiReverseButton == ButtonState.ENABLED) {
                Collections.reverse(rows);
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>(rows.size());
        for (Row row : rows) {
            result.add(row.idx);
        }
        return result;
    }

    private Comparator<Row> buildRowComparator(ButtonState state) {
        if (state == null) {
            return Comparator.comparing(r -> r.name, String::compareTo);
        }
        return switch (state) {
            case ButtonState.SORT_QUANTITY -> Comparator.comparingLong(r -> r.amount);
            case ButtonState.SORT_NAME -> Comparator.comparing(r -> r.name, String::compareTo);
            case ButtonState.SORT_MODID -> Comparator.comparing(r -> r.modIdSort, String::compareTo);
            case ButtonState.SORT_INSERTED_TIME -> Comparator.comparingLong(r -> r.ctime);
            case ButtonState.SORT_MODIFIED_TIME -> Comparator.comparingLong(r -> r.mtime);
            default -> Comparator.comparing(r -> r.name, String::compareTo);
        };
    }

    private boolean checkTextMatches(String srcText, String inputText) {
        boolean matchPinyin;
        srcText = srcText.toLowerCase(Locale.ENGLISH);
        inputText = inputText.toLowerCase(Locale.ENGLISH);
        boolean matchText = srcText.contains(inputText);
        if (!Minecraft.getInstance().options.languageCode.startsWith("zh")) {
            matchPinyin = false;
        } else if (BeyondDimensions.JECharactersLoaded) {
            matchPinyin = PinInMatches.contains(srcText, inputText);
        } else {
            String allPinyin = TinyPinyinUtils.getAllPinyin(srcText, false).toLowerCase(Locale.ENGLISH);
            String firstPinyin = TinyPinyinUtils.getFirstPinYin(srcText).toLowerCase(Locale.ENGLISH);
            matchPinyin = allPinyin.contains(inputText) || firstPinyin.contains(inputText);
        }
        return matchText || matchPinyin;
    }

    private boolean checkTooltipMatches(KeyAmount stack, String matchText) {
        List<Component> toolTips = TooltipHelper.getTooltipLines(stack, Item.TooltipContext.of((Level)this.player.level()), this.player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        return toolTips.stream().anyMatch(tooltip -> {
            String tooltipText = tooltip.getString().toLowerCase(Locale.ENGLISH);
            return this.checkTextMatches(tooltipText, matchText);
        });
    }

    private static String[] splitSearch(String s) {
        if (s == null) {
            return new String[]{"", "", ""};
        }
        s = s.toLowerCase(Locale.ENGLISH);
        int at = s.indexOf(64);
        int hash = s.indexOf(35);
        if (at < 0 && hash < 0) {
            return new String[]{s, "", ""};
        }
        String namePart = "";
        String idPart = "";
        String tipPart = "";
        if (at >= 0 && hash >= 0) {
            int first = Math.min(at, hash);
            namePart = s.substring(0, first);
            if (at < hash) {
                idPart = s.substring(at + 1, hash);
                tipPart = s.substring(hash + 1);
            } else {
                tipPart = s.substring(hash + 1, at);
                idPart = s.substring(at + 1);
            }
        } else if (at >= 0) {
            namePart = s.substring(0, at);
            idPart = s.substring(at + 1);
        } else {
            namePart = s.substring(0, hash);
            tipPart = s.substring(hash + 1);
        }
        return new String[]{namePart, idPart, tipPart};
    }

    public void updateScrollLineData(int dataSize) {
        this.maxLineData = dataSize / 9;
        if (dataSize % 9 != 0) {
            ++this.maxLineData;
        }
        this.maxLineData -= this.getLines();
        this.maxLineData = Math.max(this.maxLineData, 0);
        this.lineData = Math.max(this.lineData, 0);
        this.lineData = Math.min(this.lineData, this.maxLineData);
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }

    private record Row(int idx, String name, String modIdSort, long amount, long ctime, long mtime) {
    }
}

