/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetInterfaceBlockEntity;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.OrderedStackTypedSlot;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NetInterfaceBaseMenu
extends BDBaseMenu {
    private static final int slotStartY = 25;
    private static final int invSlotStartY = 147;
    public final StackHandler storage;
    public final StackHandler flagStorage;
    public NetInterfaceBlockEntity be;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetInterfaceBaseMenu>> Net_Interface_Menu = MENU_TYPES.register("net_interface_menu", () -> IMenuTypeExtension.create(NetInterfaceBaseMenu::new));

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, (NetInterfaceBlockEntity)playerInventory.player.level().getBlockEntity(data.readBlockPos()));
    }

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, NetInterfaceBlockEntity be) {
        super(Net_Interface_Menu.get(), id, playerInventory);
        this.storage = be.getStackHandler();
        this.flagStorage = be.getFakeStackHandler();
        this.be = be;
        this.addPlayerInv(playerInventory);
        this.addStorageSlots();
        this.addFlagSlots();
    }

    private void addStorageSlots() {
        this.vanillaQuickMoveStartIndex = this.slots.size();
        int slotCount = this.storage.getSlots();
        int cols = 9;
        int x0 = 8;
        int y0 = 43;
        int dx = 18;
        int dy = 36;
        for (int i = 0; i < slotCount; ++i) {
            int col = i % 9;
            int row = i / 9;
            int x = 8 + col * 18;
            int y = 43 + row * 36;
            this.addSlot(new OrderedStackTypedSlot(this, this.storage, i, this.inventoryStartIndex, this.inventoryEndIndex, x, y));
        }
        this.vanillaQuickMoveEndIndex = this.slots.size();
    }

    private void addFlagSlots() {
        int slotCount = this.flagStorage.getSlots();
        int cols = 9;
        int x0 = 8;
        int y0 = 25;
        int dx = 18;
        int dy = 36;
        for (int i = 0; i < slotCount; ++i) {
            int col = i % 9;
            int row = i / 9;
            int x = 8 + col * 18;
            int y = 25 + row * 36;
            this.addSlot(new FlagStackTypedSlot(this, this.flagStorage, i, x, y));
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 147 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 205));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    protected boolean shouldSendQuickData() {
        return false;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.putString("popMode", this.be.popMode.name());
        tag.putString("controlMode", this.be.controlMode.name());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        this.be.popMode = PopMode.valueOf(tag.getString("popMode"));
        this.be.controlMode = RedStoneControlMode.valueOf(tag.getString("controlMode"));
        if (!this.player.level().isClientSide()) {
            this.player.level().blockEntityChanged(this.be.getBlockPos());
            this.player.level().sendBlockUpdated(this.be.getBlockPos(), this.be.getBlockState(), this.be.getBlockState(), 2);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return this.be != null && !this.be.isRemoved();
    }
}

