/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetPumpBlockEntity;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class NetPumpMenu
extends BDBaseMenu {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetPumpMenu>> Net_Pump_Menu = MENU_TYPES.register("net_pump_menu", () -> IMenuTypeExtension.create(NetPumpMenu::new));
    private static final int slotStartY = 25;
    private static final int invSlotStartY = 111;
    private final IStackHandler storage;
    public final NetPumpBlockEntity be;

    public NetPumpMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, new StackHandler(36), (NetPumpBlockEntity)playerInventory.player.level().getBlockEntity(data.readBlockPos()));
    }

    public NetPumpMenu(int containerId, Inventory playerInventory, @Nullable IStackHandler storage, NetPumpBlockEntity be) {
        super(Net_Pump_Menu.get(), containerId, playerInventory);
        this.be = be;
        this.storage = playerInventory.player.level().isClientSide() ? new StackHandler(36) : storage;
        this.addPlayerInv(playerInventory);
        this.addFlagSlots();
    }

    private void addFlagSlots() {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                FlagStackTypedSlot flagSlot = new FlagStackTypedSlot(this, this.storage, row * 9 + col, 8 + col * 18, 25 + row * 18);
                this.addSlot(flagSlot);
            }
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 111 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 169));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    public boolean stillValid(Player player) {
        return this.be != null && !this.be.isRemoved();
    }

    @Override
    protected boolean shouldSendQuickData() {
        return false;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.putString("filter_type", this.be.filterMode.name());
        tag.putString("control_mode", this.be.controlMode.name());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        this.be.filterMode = FilterMode.valueOf(tag.getString("filter_type"));
        this.be.controlMode = RedStoneControlMode.valueOf(tag.getString("control_mode"));
        if (!this.player.level().isClientSide()) {
            this.player.level().blockEntityChanged(this.be.getBlockPos());
            this.player.level().sendBlockUpdated(this.be.getBlockPos(), this.be.getBlockState(), this.be.getBlockState(), 2);
        }
    }
}

