/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStackTypedSlot
extends Slot {
    private static final Container empty_inv = new SimpleContainer(0);
    protected final IStackHandler storage;
    protected final int quickMoveSlotStartIndex;
    protected final int quickMoveSlotEndIndex;
    protected int theSlot;
    protected boolean fake;
    protected boolean active = true;
    protected final BDBaseMenu menu;

    public AbstractStackTypedSlot(BDBaseMenu menu, IStackHandler storage, int slotIndex, int xPosition, int yPosition) {
        super(empty_inv, slotIndex, xPosition, yPosition);
        this.theSlot = slotIndex;
        this.storage = storage;
        this.menu = menu;
        this.quickMoveSlotStartIndex = -1;
        this.quickMoveSlotEndIndex = -1;
    }

    public AbstractStackTypedSlot(BDBaseMenu menu, IStackHandler storage, int slotIndex, int quickMoveSlotStartIndex, int quickMoveSlotEndIndex, int xPosition, int yPosition) {
        super(empty_inv, slotIndex, xPosition, yPosition);
        this.theSlot = slotIndex;
        this.storage = storage;
        this.menu = menu;
        this.quickMoveSlotStartIndex = quickMoveSlotStartIndex;
        this.quickMoveSlotEndIndex = quickMoveSlotEndIndex;
    }

    public IStackHandler getStorage() {
        return this.storage;
    }

    public abstract boolean isOrdered();

    public abstract void click(KeyAmount var1, int var2, Player var3);

    public abstract void quickMove(KeyAmount var1, int var2, Player var3);

    public abstract void updateChange();

    public abstract void loadChange(int var1, IStackKey<?> var2, long var3);

    public long getSlotCap() {
        return this.storage.getSlotCapacity(this.theSlot);
    }

    public KeyAmount getTypedStackFromUnifiedStorage() {
        return this.storage.getStackBySlot(this.getSlotIndex());
    }

    public ItemStack getItemStackFromUnifiedStorage() {
        KeyAmount stackType = this.storage.getStackBySlot(this.getSlotIndex());
        IStackKey<?> iStackKey = stackType.key();
        if (iStackKey instanceof ItemStackKey) {
            ItemStackKey itemStackType = (ItemStackKey)iStackKey;
            ItemStack readOnlyStack = itemStackType.getReadOnlyStack();
            readOnlyStack.setCount(BDMath.clampLongToInt(stackType.amount()));
            return readOnlyStack;
        }
        return ItemStack.EMPTY;
    }

    public KeyAmount getVanillaActualStack() {
        KeyAmount stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack.amount() > stack.key().getVanillaMaxStackSize()) {
            return new KeyAmount(stack.key(), stack.key().getVanillaMaxStackSize());
        }
        return stack;
    }

    public KeyAmount getVanillaMaxSizeStack() {
        KeyAmount stack = this.getTypedStackFromUnifiedStorage();
        if (stack.isEmpty()) {
            return stack;
        }
        return new KeyAmount(stack.key(), stack.key().getVanillaMaxStackSize());
    }

    @NotNull
    public KeyAmount getStack() {
        if (this.getSlotIndex() < 0 || this.getSlotIndex() >= this.storage.getSlots()) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        return this.storage.getStackBySlot(this.getSlotIndex());
    }

    public void setStackDirectly(IStackKey<?> key, long amount) {
    }

    public abstract KeyAmount safeInsert(IStackKey<?> var1, long var2);

    public abstract KeyAmount safeExtract(IStackKey<?> var1, long var2);

    @NotNull
    public ItemStack getItem() {
        if (this.getSlotIndex() < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = this.getItemStackFromUnifiedStorage();
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return itemStack.copy();
    }

    public boolean hasItem() {
        return !this.storage.getStackBySlot(this.getSlotIndex()).isEmpty();
    }

    public void setChanged() {
    }

    public int getSlotIndex() {
        return this.theSlot;
    }

    public boolean isSameInventory(@NotNull Slot other) {
        if (other instanceof AbstractStackTypedSlot) {
            return this.storage == ((AbstractStackTypedSlot)other).storage;
        }
        return false;
    }

    public int getContainerSlot() {
        return this.theSlot;
    }

    public void setTheSlotIndex(int index) {
        this.theSlot = index;
    }

    public long getItemCount() {
        if (this.getSlotIndex() < 0) {
            return -1L;
        }
        KeyAmount stack = this.storage.getStackBySlot(this.getSlotIndex());
        if (!stack.isEmpty()) {
            return stack.amount();
        }
        return -1L;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void set(@NotNull ItemStack stack) {
    }

    public void setByPlayer(@NotNull ItemStack newStack, @NotNull ItemStack oldStack) {
    }

    public int getMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public ItemStack remove(int amount) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack safeInsert(@NotNull ItemStack stack, int increment) {
        return stack;
    }
}

