/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.FluidHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackKeyRegistry;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Item.Custom.XpExchangeItem;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.ItemCapInteractionBlackList;
import com.wintercogs.beyonddimensions.Packet.OrderedStackTypedSlotPacket;
import com.wintercogs.beyonddimensions.Tags.ModFluidTags;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.XpUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class OrderedStackTypedSlot
extends AbstractStackTypedSlot {
    private KeyAmount lastStack = new KeyAmount(ItemStackKey.EMPTY, 0L);

    public OrderedStackTypedSlot(BDBaseMenu menu, IStackHandler stackTypedHandler, int slotIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, xPosition, yPosition);
    }

    public OrderedStackTypedSlot(BDBaseMenu menu, IStackHandler stackTypedHandler, int slotIndex, int quickMoveSlotStartIndex, int quickMoveSlotEndIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, quickMoveSlotStartIndex, quickMoveSlotEndIndex, xPosition, yPosition);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void click(KeyAmount clickStack, int button, Player player) {
        ItemStack carriedItem;
        block16: {
            AtomicBoolean handled;
            block18: {
                block21: {
                    FluidStack fluidStack;
                    KeyAmount stack;
                    FluidHandlerWrapper stackHandlerWrapper;
                    block20: {
                        block19: {
                            block17: {
                                carriedItem = this.menu.getCarried().copy();
                                if (!clickStack.isEmpty()) break block16;
                                if (carriedItem.isEmpty()) return;
                                handled = new AtomicBoolean(false);
                                if (!(carriedItem.getItem() instanceof XpExchangeItem) || button == 0) break block17;
                                int conversionRate = XpExchangeItem.getConversionRate();
                                double currentLevel = XpUtil.levelAsDouble(player);
                                int wantConversionLevel = XpExchangeItem.getXpLevelPerAction(carriedItem);
                                if (button == 1) {
                                    handled.set(true);
                                    long needRemovePlayerXp = XpUtil.xpBetweenLevels(Math.max(currentLevel - (double)wantConversionLevel, 0.0), currentLevel);
                                    int actualRemovePlayerXp = BDMath.clampLongToInt(needRemovePlayerXp);
                                    long actualInsertFluid = (long)actualRemovePlayerXp * (long)conversionRate;
                                    KeyAmount remaining = this.storage.insert(this.getSlotIndex(), new FluidStackKey(new FluidStack(ModFluids.XP_FLUID.source(), 1)), actualInsertFluid, false);
                                    if (!remaining.isEmpty()) {
                                        int needReturnXp = BDMath.clampLongToInt(remaining.amount() / 20L);
                                        actualRemovePlayerXp -= needReturnXp;
                                    }
                                    player.giveExperiencePoints(-actualRemovePlayerXp);
                                }
                                break block18;
                            }
                            if (carriedItem.getCount() != 1 || button != 1 || ItemCapInteractionBlackList.isInBlackList(carriedItem.getItem())) break block18;
                            Item currentLevel = carriedItem.getItem();
                            if (!(currentLevel instanceof BucketItem)) break block19;
                            BucketItem bucketItem = (BucketItem)currentLevel;
                            break block20;
                        }
                        if (!(carriedItem.getItem() instanceof MilkBucketItem)) break block21;
                    }
                    Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                    if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new KeyAmount(new FluidStackKey(fluidStack = stackHandlerWrapper.getStackInSlot(0)), fluidStack.getAmount())).key() != null && !stack.isEmpty()) {
                        int changedCount = BDMath.clampLongToInt(Math.min(stack.amount(), stack.key().getVanillaMaxStackSize()));
                        int remaining = (int)this.storage.insert(this.getSlotIndex(), stack.key(), changedCount, true).amount();
                        if (remaining <= 0) {
                            this.storage.insert(this.getSlotIndex(), stack.key(), changedCount, false).amount();
                            this.menu.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                            handled.set(true);
                        }
                    }
                    break block18;
                }
                CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                    Function<?, IStackHandlerWrapper<?>> handlerGetter;
                    IStackHandlerWrapper<?> stackHandlerWrapper;
                    Object handler = carriedItem.getCapability(cap);
                    if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                        for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                            int remaining;
                            int changedCount;
                            int actualInsert;
                            IStackKey typeKey = StackKeyRegistry.getType(typeId);
                            KeyAmount stack = typeKey.fromStackObject(stackHandlerWrapper.getStackInSlot(index));
                            if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(stack.amount(), stack.key().getVanillaMaxStackSize()))) - (remaining = (int)this.storage.insert(this.getSlotIndex(), stack.key(), changedCount, false).amount())) <= 0) continue;
                            long actualExtracts = stackHandlerWrapper.extract(index, actualInsert, false);
                            if (actualExtracts < (long)actualInsert) {
                                this.storage.extract(this.getSlotIndex(), (long)actualInsert - actualExtracts, false);
                            }
                            this.menu.setCarried(carriedItem.copy());
                            handled.set(true);
                            break;
                        }
                    }
                });
            }
            if (handled.get()) return;
            int changedCount = button == 0 ? carriedItem.getCount() : 1;
            int remaining = (int)this.storage.insert(this.getSlotIndex(), new ItemStackKey(carriedItem), changedCount, false).amount();
            int actualInsert = changedCount - remaining;
            int newCount = carriedItem.getCount() - actualInsert;
            if (newCount <= 0) {
                this.menu.setCarried(ItemStack.EMPTY);
                return;
            }
            ItemStack newCarriedItem = carriedItem.copy();
            newCarriedItem.setCount(newCount);
            this.menu.setCarried(newCarriedItem);
            return;
        }
        if (!this.mayPickup(player)) return;
        if (carriedItem.isEmpty()) {
            IStackKey<?> changedCount = clickStack.key();
            if (!(changedCount instanceof ItemStackKey)) return;
            ItemStackKey clickKey = (ItemStackKey)changedCount;
            int woundChangeNum = BDMath.clampLongToInt(Math.min(clickStack.amount(), clickKey.getVanillaMaxStackSize()));
            int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
            ItemStack takenItem = (ItemStack)this.storage.extract(this.getSlotIndex(), (long)actualChangeNum, false).toStack();
            if (takenItem == null) return;
            this.menu.setCarried(takenItem);
            return;
        }
        if (!this.mayPlace(carriedItem)) {
            if (!clickStack.key().isSameTypeSameComponents(new ItemStackKey(carriedItem))) return;
            return;
        }
        if (clickStack.key().isSameTypeSameComponents(new ItemStackKey(carriedItem))) {
            int changedCount = button == 0 ? carriedItem.getCount() : 1;
            int remaining = (int)this.storage.insert(this.getSlotIndex(), new ItemStackKey(carriedItem), changedCount, false).amount();
            int actualInsert = changedCount - remaining;
            int newCount = carriedItem.getCount() - actualInsert;
            if (newCount <= 0) {
                this.menu.setCarried(ItemStack.EMPTY);
                return;
            }
            ItemStack newCarriedItem = carriedItem.copy();
            newCarriedItem.setCount(newCount);
            this.menu.setCarried(newCarriedItem);
            return;
        }
        if (carriedItem.getItem() instanceof XpExchangeItem && button != 0) {
            KeyAmount actualStack = this.getStack();
            int conversionRate = XpExchangeItem.getConversionRate();
            double currentLevel = XpUtil.levelAsDouble(player);
            int wantConversionLevel = XpExchangeItem.getXpLevelPerAction(carriedItem);
            IStackKey<?> changedCount = actualStack.key();
            if (!(changedCount instanceof FluidStackKey)) return;
            FluidStackKey fluidStackKey = (FluidStackKey)changedCount;
            if (!fluidStackKey.hasTag(ModFluidTags.C_EXPERIENCE)) return;
            if (button != 1) {
                if (button != 2) return;
                long needInsertPlayerXp = XpUtil.xpBetweenLevels(currentLevel, currentLevel + (double)wantConversionLevel);
                int actualInsertPlayerXp = BDMath.clampLongToInt(needInsertPlayerXp);
                long actualRemoveFluid = actualInsertPlayerXp * conversionRate;
                KeyAmount extracted = this.storage.extract(this.getSlotIndex(), actualRemoveFluid, false);
                actualInsertPlayerXp = BDMath.clampLongToInt(extracted.amount() / 20L);
                if (actualInsertPlayerXp <= 0) return;
                player.giveExperiencePoints(actualInsertPlayerXp);
                return;
            }
            long needRemovePlayerXp = XpUtil.xpBetweenLevels(Math.max(currentLevel - (double)wantConversionLevel, 0.0), currentLevel);
            int actualRemovePlayerXp = BDMath.clampLongToInt(needRemovePlayerXp);
            long actualInsertFluid = (long)actualRemovePlayerXp * (long)conversionRate;
            KeyAmount remaining = this.storage.insert(this.getSlotIndex(), fluidStackKey, actualInsertFluid, false);
            if (!remaining.isEmpty()) {
                int needReturnXp = BDMath.clampLongToInt(remaining.amount() / 20L);
                actualRemovePlayerXp -= needReturnXp;
            }
            player.giveExperiencePoints(-actualRemovePlayerXp);
            return;
        }
        if (button == 0) {
            KeyAmount actualStack = this.getStack();
            if (!(actualStack.key() instanceof ItemStackKey)) return;
            if ((long)carriedItem.getCount() > this.getSlotCap()) return;
            if (actualStack.amount() > actualStack.key().getVanillaMaxStackSize()) return;
            KeyAmount extract = this.storage.extract(this.getSlotIndex(), actualStack.amount(), false);
            KeyAmount remaining = this.storage.insert(this.getSlotIndex(), new ItemStackKey(carriedItem), carriedItem.getCount(), true);
            if (remaining.isEmpty()) {
                this.storage.insert(this.getSlotIndex(), new ItemStackKey(carriedItem), carriedItem.getCount(), false);
                this.menu.setCarried((ItemStack)extract.toStack());
                return;
            }
            this.storage.insert(this.getSlotIndex(), extract.key(), extract.amount(), false);
            return;
        }
        if (carriedItem.getCount() != 1) return;
        if (button != 1) return;
        if (ItemCapInteractionBlackList.isInBlackList(carriedItem.getItem())) return;
        if (!(carriedItem.getItem() instanceof BucketItem) && !(carriedItem.getItem() instanceof MilkBucketItem)) {
            CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                Function<?, IStackHandlerWrapper<?>> handlerGetter;
                IStackHandlerWrapper<?> stackHandlerWrapper;
                Object handler;
                if (clickStack.key().getTypeId().equals(typeId) && (handler = carriedItem.getCapability(cap)) != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                    KeyAmount trueStack = this.storage.getStackBySlot(this.getSlotIndex());
                    long tureCount = 0L;
                    if (trueStack.key().isSameTypeSameComponents(clickStack.key())) {
                        tureCount = trueStack.amount();
                    }
                    int changedCount = BDMath.clampLongToInt(Math.min(tureCount, clickStack.key().getVanillaMaxStackSize()));
                    int remaining = (int)stackHandlerWrapper.insert(clickStack.toStack(), false);
                    int actualInsert = changedCount - remaining;
                    this.storage.extract(this.getSlotIndex(), (long)actualInsert, false);
                    this.menu.setCarried(carriedItem.copy());
                }
            });
            return;
        }
        if (carriedItem.getItem() == Items.BUCKET) {
            IStackKey<?> extract = clickStack.key();
            if (!(extract instanceof FluidStackKey)) return;
            FluidStackKey fluidStackKey = (FluidStackKey)extract;
            Item filledBucket = fluidStackKey.getSource().getBucket();
            if (filledBucket == Items.AIR) return;
            if (clickStack.amount() < 1000L) return;
            this.storage.extract(this.getSlotIndex(), 1000L, false);
            this.menu.setCarried(new ItemStack((ItemLike)filledBucket));
            return;
        }
        Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) return;
        FluidHandlerWrapper stackHandlerWrapper = new FluidHandlerWrapper(handler);
        if (stackHandlerWrapper.getSlots() <= 0) return;
        FluidStack typeStack = stackHandlerWrapper.getStackInSlot(0);
        KeyAmount stack = new KeyAmount(new FluidStackKey(typeStack), typeStack.getAmount());
        if (stack.key() == null) return;
        if (stack.isEmpty()) return;
        int changedCount = BDMath.clampLongToInt(Math.min(stack.amount(), stack.key().getVanillaMaxStackSize()));
        int remaining = (int)this.storage.insert(this.getSlotIndex(), stack.key(), changedCount, true).amount();
        if (remaining > 0) return;
        this.storage.insert(this.getSlotIndex(), stack.key(), changedCount, false);
        this.menu.setCarried(new ItemStack((ItemLike)Items.BUCKET));
    }

    @Override
    public void quickMove(KeyAmount clickStack, int button, Player player) {
        if (this.quickMoveSlotStartIndex < 0 || this.quickMoveSlotEndIndex < 0 || this.quickMoveSlotStartIndex >= this.quickMoveSlotEndIndex) {
            return;
        }
        if (!clickStack.isEmpty()) {
            KeyAmount trueStack = new KeyAmount(this.storage.getStackBySlot(this.theSlot).key(), clickStack.amount());
            for (int targetSlotIndex = this.quickMoveSlotStartIndex; targetSlotIndex < this.quickMoveSlotEndIndex && !trueStack.isEmpty(); ++targetSlotIndex) {
                FluidStackKey trueFluidTypedKey;
                Object extract;
                Slot slot = (Slot)this.menu.slots.get(targetSlotIndex);
                if (slot instanceof AbstractStackTypedSlot) {
                    AbstractStackTypedSlot aSlot = (AbstractStackTypedSlot)slot;
                    KeyAmount extract2 = this.safeExtract(trueStack.key(), trueStack.amount());
                    KeyAmount remaining = aSlot.safeInsert(extract2.key(), extract2.amount());
                    if (!remaining.isEmpty()) {
                        this.safeInsert(remaining.key(), remaining.amount());
                    }
                    trueStack = remaining;
                    continue;
                }
                IStackKey<?> key = trueStack.key();
                if (key instanceof ItemStackKey) {
                    ItemStackKey trueItemTypedKey = (ItemStackKey)key;
                    extract = (ItemStack)this.safeExtract(trueItemTypedKey, trueStack.amount()).toStack();
                    ItemStack remaining = slot.safeInsert((ItemStack)extract);
                    if (!remaining.isEmpty()) {
                        this.safeInsert(new ItemStackKey(remaining), (long)remaining.getCount());
                    }
                    trueStack = new KeyAmount(new ItemStackKey(remaining), remaining.getCount());
                    continue;
                }
                if (!(key instanceof FluidStackKey) || (trueFluidTypedKey = (FluidStackKey)key).getSource().getBucket() == Items.AIR) continue;
                extract = this.safeExtract(trueFluidTypedKey, 1000L);
                if (((KeyAmount)extract).amount() != 1000L) {
                    this.safeInsert(((KeyAmount)extract).key(), ((KeyAmount)extract).amount());
                    break;
                }
                KeyAmount bucket = this.storage.extract(new ItemStackKey(new ItemStack((ItemLike)Items.BUCKET)), 1L, false);
                if (bucket.isEmpty()) {
                    this.safeInsert(((KeyAmount)extract).key(), ((KeyAmount)extract).amount());
                    break;
                }
                Item bucketItem = trueFluidTypedKey.getSource().getBucket();
                ItemStack insertStack = new ItemStack((ItemLike)bucketItem);
                ItemStack remaining = slot.safeInsert(insertStack);
                if (!remaining.isEmpty()) {
                    this.safeInsert(((KeyAmount)extract).key(), ((KeyAmount)extract).amount());
                    this.storage.insert(bucket.key(), bucket.amount(), false);
                    continue;
                }
                trueStack = new KeyAmount(trueFluidTypedKey, trueStack.amount() - 1000L);
                break;
            }
            this.setChanged();
        }
    }

    @Override
    public KeyAmount safeInsert(IStackKey<?> key, long amount) {
        if (key != null) {
            return this.storage.insert(this.theSlot, key, amount, false);
        }
        return new KeyAmount(ItemStackKey.EMPTY, 0L);
    }

    @Override
    public KeyAmount safeExtract(IStackKey<?> key, long amount) {
        if (key != null && this.getStack() != null && key.getTypeId().equals((Object)this.getStack().key().getTypeId()) && key.isSameTypeSameComponents(this.getStack().key())) {
            return this.storage.extract(this.theSlot, amount, false);
        }
        return new KeyAmount(key, amount);
    }

    @Override
    public void updateChange() {
        KeyAmount currentStack = this.storage.getStackBySlot(this.getSlotIndex());
        if (currentStack.key() == null) {
            this.lastStack = new KeyAmount(ItemStackKey.EMPTY, 0L);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)new OrderedStackTypedSlotPacket(this.index, this.theSlot, this.lastStack.key(), 0L), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (!(currentStack.isEmpty() && this.lastStack.isEmpty() || this.lastStack.amount() == currentStack.amount() && this.lastStack.key().getTypeId().equals((Object)currentStack.key().getTypeId()) && this.lastStack.key().isSameTypeSameComponents(currentStack.key()))) {
            this.lastStack = currentStack;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)new OrderedStackTypedSlotPacket(this.index, this.theSlot, this.lastStack.key(), this.lastStack.amount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void loadChange(int where, IStackKey<?> newStack, long newAmount) {
        this.storage.setStackDirectly(where, newStack, newAmount);
    }
}

