/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.SlotGroupSync;
import com.wintercogs.beyonddimensions.Packet.BatchTransferPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import com.wintercogs.beyonddimensions.Packet.ClickTransferCraftButtonPacket;
import com.wintercogs.beyonddimensions.Packet.DisorderedSlotGroupSyncPacket;
import com.wintercogs.beyonddimensions.Packet.NetControlActionPacket;
import com.wintercogs.beyonddimensions.Packet.OpenNetGuiPacket;
import com.wintercogs.beyonddimensions.Packet.OrderedStackTypedSlotPacket;
import com.wintercogs.beyonddimensions.Packet.PickBlockFromNetPacket;
import com.wintercogs.beyonddimensions.Packet.PlayerPermissionInfoPacket;
import com.wintercogs.beyonddimensions.Packet.PutHandItemToNetPacket;
import com.wintercogs.beyonddimensions.Packet.QuickDataTagPacket;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import com.wintercogs.beyonddimensions.Packet.SetSlotDirectlyPacket;
import com.wintercogs.beyonddimensions.Packet.ToggleMagnetPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;

public class ClientPayloadHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleOpenNetGuiPacket(OpenNetGuiPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> LOGGER.info(packet.uuid()));
    }

    public void handleCallSeverClickPacket(CallSeverClickPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handlePlayerPermissionInfoPacket(PlayerPermissionInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetControlMenu)) {
                return;
            }
            NetControlMenu menu = (NetControlMenu)player.containerMenu;
            menu.loadPlayerInfo(packet.infoMap());
        });
    }

    public void handleNetControlActionPacket(NetControlActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleRecipeFillC2SPacket(RecipeFillC2SPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleClickTransferCraftButtonPacket(ClickTransferCraftButtonPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleBatchTransferPacket(BatchTransferPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handlePickBlockFromNetPacket(PickBlockFromNetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handlePutHandItemToNetPacket(PutHandItemToNetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleOrderedStackTypedSlotPacket(OrderedStackTypedSlotPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AbstractContainerMenu) {
                AbstractContainerMenu menu = patt0$temp;
                Object patt1$temp = menu.slots.get(packet.slotId());
                if (patt1$temp instanceof AbstractStackTypedSlot) {
                    AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)((Object)patt1$temp));
                    slot.loadChange(packet.slotIndex(), packet.stack(), packet.newAmount());
                }
            }
        });
    }

    public void handleSetSlotDirectlyPacket(SetSlotDirectlyPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AbstractContainerMenu) {
                AbstractContainerMenu menu = patt0$temp;
                Object patt1$temp = menu.slots.get(packet.slotId());
                if (patt1$temp instanceof AbstractStackTypedSlot) {
                    AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)((Object)patt1$temp));
                    slot.setStackDirectly(packet.stack().key(), packet.stack().amount());
                }
            }
        });
    }

    public void handleDisorderedSlotGroupSyncPacket(DisorderedSlotGroupSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof BDBaseMenu) {
                BDBaseMenu menu = (BDBaseMenu)patt0$temp;
                SlotGroupSync sync = menu.slotGroupSyncs.get(packet.groupId());
                if (sync != null) {
                    sync.loadChange(packet.keys(), packet.newCounts(), packet.newModifiedTime(), packet.newInsertedTime());
                    sync.afterLoadChange();
                }
            }
        });
    }

    public void handleQuickDataTagPacket(QuickDataTagPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof BDBaseMenu) {
                BDBaseMenu menu = (BDBaseMenu)patt0$temp;
                menu.readQuickDataTag(packet.tag());
            }
        });
    }

    public void handleToggleMagnetPacket(ToggleMagnetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }
}

