/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.AbstractUnorderedStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataComponents.Custom.ItemStackContents;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.GUI.NetMenuType;
import com.wintercogs.beyonddimensions.Item.Custom.NetMagnetItem;
import com.wintercogs.beyonddimensions.Item.Custom.NetTerminalItem;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.NetControlMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.BatchTransferPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import com.wintercogs.beyonddimensions.Packet.ClickTransferCraftButtonPacket;
import com.wintercogs.beyonddimensions.Packet.DisorderedSlotGroupSyncPacket;
import com.wintercogs.beyonddimensions.Packet.NetControlActionPacket;
import com.wintercogs.beyonddimensions.Packet.OpenNetGuiPacket;
import com.wintercogs.beyonddimensions.Packet.OrderedStackTypedSlotPacket;
import com.wintercogs.beyonddimensions.Packet.PickBlockFromNetPacket;
import com.wintercogs.beyonddimensions.Packet.PlayerPermissionInfoPacket;
import com.wintercogs.beyonddimensions.Packet.PutHandItemToNetPacket;
import com.wintercogs.beyonddimensions.Packet.QuickDataTagPacket;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import com.wintercogs.beyonddimensions.Packet.SetSlotDirectlyPacket;
import com.wintercogs.beyonddimensions.Packet.ToggleMagnetPacket;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ServerPayloadHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleOpenNetGuiPacket(OpenNetGuiPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
            if (net != null) {
                NetMenuType targetMenu = packet.target();
                if (targetMenu == NetMenuType.NET_CRAFT_MENU) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new DimensionsCraftMenu(DimensionsCraftMenu.Dimensions_Craft_Menu.get(), containerId, playerInventory, net.getUnifiedStorage(), null, null), (Component)Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu")));
                } else if (targetMenu == NetMenuType.NET_MENU) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new DimensionsNetMenu(DimensionsNetMenu.Dimensions_Net_Menu.get(), containerId, playerInventory, net.getUnifiedStorage()), (Component)Component.translatable((String)"menu.title.beyonddimensions.dimensionnetmenu")));
                } else if (targetMenu == NetMenuType.NET_CRAFT_TERMINAL) {
                    ItemStack terminalStack = null;
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof NetTerminalItem) {
                        terminalStack = player.getItemInHand(InteractionHand.MAIN_HAND);
                    } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof NetTerminalItem) {
                        terminalStack = player.getItemInHand(InteractionHand.OFF_HAND);
                    } else {
                        for (ItemStack itemStack : player.getInventory().items) {
                            if (!(itemStack.getItem() instanceof NetTerminalItem)) continue;
                            terminalStack = itemStack;
                            break;
                        }
                        if (terminalStack == null && BeyondDimensions.CuriosLoaded) {
                            terminalStack = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(itemStack -> itemStack.getItem() instanceof NetTerminalItem && itemStack.has(ModDataComponents.NET_ID_DATA) && (Integer)itemStack.get(ModDataComponents.NET_ID_DATA) >= 0)).map(slotResult -> slotResult.stack()).orElse(null);
                        }
                    }
                    if (terminalStack != null) {
                        if (terminalStack.get(ModDataComponents.CRAFT_SLOTS) == null) {
                            terminalStack.set(ModDataComponents.CRAFT_SLOTS, (Object)new ItemStackContents((NonNullList<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY)));
                        }
                        NetTerminalItem.contextMap.put(player, new NetTerminalItem.MenuTriggerContext(InteractionHand.MAIN_HAND, terminalStack));
                        player.openMenu((MenuProvider)((NetTerminalItem)terminalStack.getItem()));
                    }
                }
            }
        });
    }

    public void handleCallSeverClickPacket(CallSeverClickPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof BDBaseMenu) {
                BDBaseMenu menu = (BDBaseMenu)patt0$temp;
                menu.customClickHandler(packet.slotIndex(), packet.clickItem(), packet.button(), packet.shiftDown());
                menu.broadcastChanges();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new CallSeverClickPacket(1, new KeyAmount(ItemStackKey.EMPTY, 0L), 1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public void handlePlayerPermissionInfoPacket(PlayerPermissionInfoPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleNetControlActionPacket(NetControlActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player.containerMenu instanceof NetControlMenu)) {
                return;
            }
            NetControlMenu menu = (NetControlMenu)player.containerMenu;
            menu.handlePlayerAction(packet.receiver(), packet.action());
        });
    }

    public void handleRecipeFillC2SPacket(RecipeFillC2SPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsCraftMenu) {
                DimensionsCraftMenu menu = (DimensionsCraftMenu)patt0$temp;
                menu.transferRecipe(packet.keys(), packet.amount());
            }
        });
    }

    public void handleClickTransferCraftButtonPacket(ClickTransferCraftButtonPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DimensionsCraftMenu) {
                DimensionsCraftMenu menu = (DimensionsCraftMenu)patt0$temp;
                menu.cleanCraftSlots(packet.toStorage());
            }
        });
    }

    public void handleBatchTransferPacket(BatchTransferPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            IStackKey<?> patt0$temp = packet.clickStack().key();
            if (patt0$temp instanceof ItemStackKey) {
                ItemStackKey clickItem = (ItemStackKey)patt0$temp;
                Player player = context.player();
                AbstractContainerMenu patt1$temp = player.containerMenu;
                if (patt1$temp instanceof BDBaseMenu) {
                    BDBaseMenu menu = (BDBaseMenu)patt1$temp;
                    if (packet.dirToStorage()) {
                        for (Slot invSlot : menu.slots) {
                            if (menu.inventoryStartIndex > invSlot.index || invSlot.index >= menu.inventoryEndIndex || !clickItem.equals(new ItemStackKey(invSlot.getItem()))) continue;
                            menu.customClickHandler(invSlot.index, new KeyAmount(new ItemStackKey(invSlot.getItem()), invSlot.getItem().getCount()), 0, true);
                        }
                    } else if (menu instanceof DimensionsNetMenu) {
                        DimensionsNetMenu netMenu = (DimensionsNetMenu)menu;
                        if (!packet.clickStack().isEmpty()) {
                            AbstractUnorderedStackHandler storage = netMenu.storage;
                            for (int targetSlotIndex = menu.inventoryStartIndex; targetSlotIndex < menu.inventoryEndIndex && storage.hasStack(clickItem); ++targetSlotIndex) {
                                Slot slot = (Slot)menu.slots.get(targetSlotIndex);
                                KeyAmount extract = storage.extract(clickItem, Integer.MAX_VALUE, false);
                                Object patt2$temp = extract.toStack();
                                if (patt2$temp instanceof ItemStack) {
                                    ItemStack extractedStack = (ItemStack)patt2$temp;
                                    ItemStack remaining = slot.safeInsert(extractedStack);
                                    if (remaining.isEmpty()) continue;
                                    storage.insert(new ItemStackKey(remaining), remaining.getCount(), false);
                                    continue;
                                }
                                storage.insert(extract.key(), extract.amount(), false);
                            }
                        }
                    }
                    menu.broadcastChanges();
                }
            }
        });
    }

    public void handlePickBlockFromNetPacket(PickBlockFromNetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!player.getMainHandItem().isEmpty()) {
                return;
            }
            DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
            if (net == null) {
                return;
            }
            UnifiedStorage storage = net.getUnifiedStorage();
            IStackKey target = null;
            for (KeyAmount stack : storage.getStorage()) {
                ItemStackKey itemStackKey;
                IStackKey<?> patt0$temp = stack.key();
                if (!(patt0$temp instanceof ItemStackKey) || (itemStackKey = (ItemStackKey)patt0$temp).getSource() != packet.targetStack().getItem()) continue;
                target = itemStackKey;
                break;
            }
            if (target != null && player.getMainHandItem().isEmpty()) {
                ItemStack extract = (ItemStack)storage.extract(target, target.getVanillaMaxStackSize(), false).toStack();
                player.setItemInHand(InteractionHand.MAIN_HAND, extract);
            }
        });
    }

    public void handlePutHandItemToNetPacket(PutHandItemToNetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player.getMainHandItem().isEmpty()) {
                return;
            }
            DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
            if (net == null) {
                return;
            }
            UnifiedStorage storage = net.getUnifiedStorage();
            KeyAmount remaining = storage.insert(new ItemStackKey(player.getMainHandItem()), player.getMainHandItem().getCount(), false);
            player.getMainHandItem().setCount(BDMath.clampLongToInt(remaining.amount()));
        });
    }

    public void handleOrderedStackTypedSlotPacket(OrderedStackTypedSlotPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleSetSlotDirectlyPacket(SetSlotDirectlyPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AbstractContainerMenu) {
                AbstractContainerMenu menu = patt0$temp;
                Object patt1$temp = menu.slots.get(packet.slotId());
                if (patt1$temp instanceof AbstractStackTypedSlot) {
                    AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)((Object)patt1$temp));
                    slot.setStackDirectly(packet.stack().key(), packet.stack().amount());
                }
            }
        });
    }

    public void handleDisorderedSlotGroupSyncPacket(DisorderedSlotGroupSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {});
    }

    public void handleQuickDataTagPacket(QuickDataTagPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof BDBaseMenu) {
                BDBaseMenu menu = (BDBaseMenu)patt0$temp;
                menu.readQuickDataTag(packet.tag());
            }
        });
    }

    public void handleToggleMagnetPacket(ToggleMagnetPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            for (ItemStack stack : player.getInventory().items) {
                if (!(stack.getItem() instanceof NetMagnetItem) || !stack.has(ModDataComponents.CONTROL_MODE)) continue;
                if (stack.get(ModDataComponents.CONTROL_MODE) == RedStoneControlMode.IGNORE) {
                    stack.set(ModDataComponents.CONTROL_MODE, (Object)RedStoneControlMode.NOT_WORKING);
                    player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.magnet.close"));
                    continue;
                }
                if (stack.get(ModDataComponents.CONTROL_MODE) != RedStoneControlMode.NOT_WORKING) continue;
                stack.set(ModDataComponents.CONTROL_MODE, (Object)RedStoneControlMode.IGNORE);
                player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.magnet.open"));
            }
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                List<ItemStack> curios = handler.findCurios(stack -> !stack.isEmpty()).stream().map(SlotResult::stack).toList();
                for (ItemStack stack2 : curios) {
                    if (!(stack2.getItem() instanceof NetMagnetItem) || !stack2.has(ModDataComponents.CONTROL_MODE)) continue;
                    if (stack2.get(ModDataComponents.CONTROL_MODE) == RedStoneControlMode.IGNORE) {
                        stack2.set(ModDataComponents.CONTROL_MODE, (Object)RedStoneControlMode.NOT_WORKING);
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.magnet.close"));
                        continue;
                    }
                    if (stack2.get(ModDataComponents.CONTROL_MODE) != RedStoneControlMode.NOT_WORKING) continue;
                    stack2.set(ModDataComponents.CONTROL_MODE, (Object)RedStoneControlMode.IGNORE);
                    player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.magnet.open"));
                }
            });
        });
    }
}

