/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Unit;

import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class DataComponentPatchHelper {
    private static final byte[] EMPTY_BYTES = DataComponentPatchHelper.buildEmptyBytes();
    private static final byte[] UNAVAILABLE_BYTES = new byte[0];

    private static byte[] buildEmptyBytes() {
        ByteBuf buf = Unpooled.buffer((int)16);
        try {
            FriendlyByteBuf.writeNbt((ByteBuf)buf, (Tag)new CompoundTag());
            byte[] out = new byte[buf.readableBytes()];
            buf.readBytes(out);
            byte[] byArray = out;
            return byArray;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toCanonicalBytes(DataComponentPatch patch, HolderLookup.Provider registries) {
        if (patch == null || patch.isEmpty()) {
            return EMPTY_BYTES;
        }
        Tag root = DataComponentPatch.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)patch).result().orElse(null);
        if (root == null) {
            return UNAVAILABLE_BYTES;
        }
        Tag canon = DataComponentPatchHelper.canonicalize(root);
        ByteBuf raw = null;
        try {
            CompoundTag ct;
            raw = Unpooled.buffer((int)Math.max(64, 8 * DataComponentPatchHelper.sizeHint(canon)));
            FriendlyByteBuf.writeNbt((ByteBuf)raw, (Tag)(canon instanceof CompoundTag ? (ct = (CompoundTag)canon) : DataComponentPatchHelper.wrap(canon)));
            byte[] out = new byte[raw.readableBytes()];
            raw.readBytes(out);
            byte[] byArray = out;
            return byArray;
        }
        catch (Throwable t) {
            byte[] byArray = UNAVAILABLE_BYTES;
            return byArray;
        }
        finally {
            if (raw != null) {
                raw.release();
            }
        }
    }

    private static Tag canonicalize(Tag in) {
        if (in instanceof CompoundTag) {
            CompoundTag ct = (CompoundTag)in;
            ArrayList keys = new ArrayList(ct.getAllKeys());
            Collections.sort(keys);
            CompoundTag out = new CompoundTag();
            for (String k : keys) {
                out.put(k, DataComponentPatchHelper.canonicalize(ct.get(k)));
            }
            return out;
        }
        if (in instanceof ListTag) {
            ListTag lt = (ListTag)in;
            ListTag out = new ListTag();
            for (Tag elem : lt) {
                out.add((Object)DataComponentPatchHelper.canonicalize(elem));
            }
            return out;
        }
        return in;
    }

    private static CompoundTag wrap(Tag t) {
        CompoundTag wrap = new CompoundTag();
        wrap.put("value", t);
        return wrap;
    }

    private static int sizeHint(Tag t) {
        if (t instanceof CompoundTag) {
            CompoundTag ct = (CompoundTag)t;
            return Math.max(1, ct.size() * 4);
        }
        if (t instanceof ListTag) {
            ListTag lt = (ListTag)t;
            return Math.max(1, lt.size() * 4);
        }
        return 4;
    }
}

