/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Unit;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public class TooltipHelper {
    private static final AtomicLong EPOCH = new AtomicLong(0L);
    private static final Map<IStackKey<?>, List<Component>> NORMAL_CACHE = new ConcurrentHashMap();
    private static final Map<IStackKey<?>, List<Component>> ADVANCED_CACHE = new ConcurrentHashMap();
    private static final Map<IStackKey<?>, CompletableFuture<List<Component>>> NORMAL_PENDING = new ConcurrentHashMap();
    private static final Map<IStackKey<?>, CompletableFuture<List<Component>>> ADVANCED_PENDING = new ConcurrentHashMap();
    private static final ExecutorService TOOLTIP_EXECUTOR = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), r -> {
        Thread t = new Thread(r, "Tooltip-Loader");
        t.setDaemon(true);
        return t;
    });

    private static CompletableFuture<List<Component>> loadAsync(KeyAmount stack, Item.TooltipContext ctx, @Nullable Player player, TooltipFlag flag, Map<IStackKey<?>, List<Component>> cache, Map<IStackKey<?>, CompletableFuture<List<Component>>> pending) {
        long taskEpoch = EPOCH.get();
        CompletableFuture future = pending.computeIfAbsent(stack.key(), s -> CompletableFuture.supplyAsync(() -> stack.key().getRender().getTooltipLines(stack.key(), stack.amount(), ctx, player, flag), TOOLTIP_EXECUTOR));
        if (future.getNumberOfDependents() == 0) {
            future.whenCompleteAsync((tooltip, err) -> {
                pending.remove(stack.key());
                if (err != null) {
                    err.printStackTrace();
                    return;
                }
                if (taskEpoch == EPOCH.get()) {
                    cache.put(stack.key(), (List<Component>)tooltip);
                }
            }, (Executor)TOOLTIP_EXECUTOR);
        }
        return future;
    }

    public static List<Component> getTooltipLines(KeyAmount stack, Item.TooltipContext ctx, @Nullable Player player, TooltipFlag flag) {
        boolean advanced = flag.isAdvanced();
        Map<IStackKey<?>, List<Component>> cache = advanced ? ADVANCED_CACHE : NORMAL_CACHE;
        Map<IStackKey<?>, CompletableFuture<List<Component>>> pending = advanced ? ADVANCED_PENDING : NORMAL_PENDING;
        List<Component> cached = cache.get(stack.key());
        if (cached != null) {
            return cached;
        }
        try {
            return TooltipHelper.loadAsync(stack, ctx, player, flag, cache, pending).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        catch (ExecutionException ee) {
            ee.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static void readAsCache(List<KeyAmount> stacks, Item.TooltipContext ctx, @Nullable Player player, TooltipFlag flag) {
        boolean advanced = flag.isAdvanced();
        Map<IStackKey<?>, List<Component>> cache = advanced ? ADVANCED_CACHE : NORMAL_CACHE;
        Map<IStackKey<?>, CompletableFuture<List<Component>>> pending = advanced ? ADVANCED_PENDING : NORMAL_PENDING;
        for (KeyAmount stack : stacks) {
            if (cache.containsKey(stack.key())) continue;
            TooltipHelper.loadAsync(stack, ctx, player, flag, cache, pending);
        }
    }

    public static void clearCache() {
        EPOCH.incrementAndGet();
        NORMAL_CACHE.clear();
        ADVANCED_CACHE.clear();
        NORMAL_PENDING.clear();
        ADVANCED_PENDING.clear();
    }
}

