/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.captcha;

import com.google.common.primitives.Floats;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.LinearGradientPaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.protocol.packets.data.MapData;
import net.elytrium.limboapi.api.protocol.packets.data.MapPalette;
import net.elytrium.limbofilter.LimboFilter;
import net.elytrium.limbofilter.Settings;
import net.elytrium.limbofilter.cache.captcha.CachedCaptcha;
import net.elytrium.limbofilter.captcha.CaptchaHolder;
import net.elytrium.limbofilter.captcha.map.CraftMapCanvas;
import net.elytrium.limbofilter.captcha.painter.CaptchaPainter;
import net.elytrium.limbofilter.captcha.painter.RenderedFont;

public class CaptchaGenerator {
    private final CaptchaPainter painter;
    private final List<CraftMapCanvas> backplates = new ArrayList<CraftMapCanvas>();
    private final List<RenderedFont> fonts = new LinkedList<RenderedFont>();
    private final List<byte[]> colors = new LinkedList<byte[]>();
    private final LimboFilter plugin;
    private ThreadPoolExecutor executor;
    private boolean shouldStop;
    private CachedCaptcha cachedCaptcha;
    private CachedCaptcha tempCachedCaptcha;
    private ThreadLocal<Iterator<CraftMapCanvas>> backplatesIterator;
    private ThreadLocal<Iterator<RenderedFont>> fontIterator;
    private ThreadLocal<Iterator<byte[]>> colorIterator;

    public CaptchaGenerator(LimboFilter plugin) {
        this.plugin = plugin;
        this.painter = Settings.IMP.MAIN.FRAMED_CAPTCHA.FRAMED_CAPTCHA_ENABLED ? new CaptchaPainter(128 * Settings.IMP.MAIN.FRAMED_CAPTCHA.WIDTH, 128 * Settings.IMP.MAIN.FRAMED_CAPTCHA.HEIGHT) : new CaptchaPainter(128, 128);
    }

    public void initializeGenerator() {
        try {
            for (String backplatePath : Settings.IMP.MAIN.CAPTCHA_GENERATOR.BACKPLATE_PATHS) {
                if (backplatePath.isEmpty()) continue;
                CraftMapCanvas craftMapCanvas = this.createCraftMapCanvas();
                craftMapCanvas.drawImage(this.resizeIfNeeded(ImageIO.read(this.plugin.getFile(backplatePath)), this.painter.getWidth(), this.painter.getHeight()), this.painter.getWidth(), this.painter.getHeight());
                this.backplates.add(craftMapCanvas);
            }
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2);
        }
        if (Settings.IMP.MAIN.CAPTCHA_GENERATOR.SAVE_NUMBER_SPELLING_OUTPUT) {
            int from = (int)Math.pow(10.0, Settings.IMP.MAIN.CAPTCHA_GENERATOR.LENGTH - 1);
            int to = from * 10;
            try (FileOutputStream output = new FileOutputStream("number_spelling.txt");){
                for (int i2 = from; i2 < to; ++i2) {
                    String result = this.spellNumber(i2);
                    ((OutputStream)output).write(String.format("%d %s%s", i2, result, System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e3) {
                throw new IllegalArgumentException(e3);
            }
        }
        this.fonts.clear();
        float fontSize = (float)Settings.IMP.MAIN.CAPTCHA_GENERATOR.RENDER_FONT_SIZE;
        if (Settings.IMP.MAIN.FRAMED_CAPTCHA.FRAMED_CAPTCHA_ENABLED && Settings.IMP.MAIN.FRAMED_CAPTCHA.AUTOSCALE_FONT) {
            fontSize *= (float)Math.min(Settings.IMP.MAIN.FRAMED_CAPTCHA.WIDTH, Settings.IMP.MAIN.FRAMED_CAPTCHA.HEIGHT);
        }
        Map<TextAttribute, Boolean> textSettings = Map.of(TextAttribute.SIZE, Float.valueOf(fontSize), TextAttribute.STRIKETHROUGH, Settings.IMP.MAIN.CAPTCHA_GENERATOR.STRIKETHROUGH, TextAttribute.UNDERLINE, Settings.IMP.MAIN.CAPTCHA_GENERATOR.UNDERLINE);
        if (Settings.IMP.MAIN.CAPTCHA_GENERATOR.USE_STANDARD_FONTS) {
            this.fonts.add(this.getRenderedFont(new Font("SansSerif", 0, (int)fontSize).deriveFont(textSettings)));
            this.fonts.add(this.getRenderedFont(new Font("Serif", 0, (int)fontSize).deriveFont(textSettings)));
            this.fonts.add(this.getRenderedFont(new Font("Monospaced", 0, (int)fontSize).deriveFont(textSettings)));
        }
        if (Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONTS_PATH != null) {
            Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONTS_PATH.forEach(fontFile -> {
                try {
                    if (!fontFile.isEmpty()) {
                        LimboFilter.getLogger().info("Loading font " + fontFile + ".");
                        Font font = Font.createFont(0, this.plugin.getFile((String)fontFile));
                        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                        this.fonts.add(this.getRenderedFont(font.deriveFont(textSettings)));
                    }
                }
                catch (FontFormatException | IOException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
        if (Settings.IMP.MAIN.CAPTCHA_GENERATOR.GRADIENT.GRADIENT_ENABLED) {
            BufferedImage gradientImage = new BufferedImage(this.painter.getWidth(), this.painter.getHeight(), 1);
            int[] imageData = ((DataBufferInt)gradientImage.getRaster().getDataBuffer()).getData();
            Graphics2D graphics = gradientImage.createGraphics();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            Settings.MAIN.CAPTCHA_GENERATOR.GRADIENT settings = Settings.IMP.MAIN.CAPTCHA_GENERATOR.GRADIENT;
            Color[] colors = (Color[])Settings.IMP.MAIN.CAPTCHA_GENERATOR.RGB_COLOR_LIST.stream().map(s -> Color.decode("#" + s)).toArray(Color[]::new);
            List<Double> fractions = settings.FRACTIONS;
            if (fractions == null || fractions.isEmpty()) {
                double step = 1.0 / (double)colors.length;
                fractions = IntStream.range(0, colors.length).mapToDouble(i -> (double)i * step).boxed().collect(Collectors.toList());
            }
            if (colors.length != fractions.size()) {
                throw new IllegalStateException("The color list and fraction list must contain the same number of elements");
            }
            for (int i3 = 0; i3 < settings.GRADIENTS_COUNT; ++i3) {
                LinearGradientPaint paint = new LinearGradientPaint((float)settings.START_X + random.nextFloat() * (float)settings.START_X_RANDOMNESS * (float)this.painter.getWidth(), (float)settings.START_Y + random.nextFloat() * (float)settings.START_Y_RANDOMNESS * (float)this.painter.getHeight(), (float)settings.END_X - random.nextFloat() * (float)settings.END_X_RANDOMNESS * (float)this.painter.getWidth(), (float)settings.END_Y - random.nextFloat() * (float)settings.END_Y_RANDOMNESS * (float)this.painter.getHeight(), Floats.toArray(fractions), colors);
                graphics.setPaint(paint);
                graphics.fillRect(0, 0, gradientImage.getWidth(), gradientImage.getHeight());
                this.colors.add(MapPalette.imageToBytes((int[])imageData, (byte[])new byte[this.painter.getWidth() * this.painter.getHeight()], (ProtocolVersion)ProtocolVersion.MAXIMUM_VERSION));
            }
            graphics.dispose();
        } else {
            Settings.IMP.MAIN.CAPTCHA_GENERATOR.RGB_COLOR_LIST.forEach(e -> this.colors.add(new byte[]{MapPalette.tryFastMatchColor((int)(Integer.parseInt(e, 16) | 0xFF000000), (ProtocolVersion)ProtocolVersion.MAXIMUM_VERSION)}));
        }
        this.backplatesIterator = ThreadLocal.withInitial(this.backplates::listIterator);
        this.fontIterator = ThreadLocal.withInitial(this.fonts::listIterator);
        this.colorIterator = ThreadLocal.withInitial(this.colors::listIterator);
    }

    private CraftMapCanvas createCraftMapCanvas() {
        if (Settings.IMP.MAIN.FRAMED_CAPTCHA.FRAMED_CAPTCHA_ENABLED) {
            return new CraftMapCanvas(Settings.IMP.MAIN.FRAMED_CAPTCHA.WIDTH, Settings.IMP.MAIN.FRAMED_CAPTCHA.HEIGHT);
        }
        return new CraftMapCanvas(1, 1);
    }

    private RenderedFont getRenderedFont(Font font) {
        boolean scaleFont = Settings.IMP.MAIN.FRAMED_CAPTCHA.FRAMED_CAPTCHA_ENABLED && Settings.IMP.MAIN.FRAMED_CAPTCHA.AUTOSCALE_FONT;
        int multiplierX = scaleFont ? Settings.IMP.MAIN.FRAMED_CAPTCHA.WIDTH : 1;
        int multiplierY = scaleFont ? Settings.IMP.MAIN.FRAMED_CAPTCHA.HEIGHT : 1;
        return new RenderedFont(font, new FontRenderContext(null, true, true), Settings.IMP.MAIN.CAPTCHA_GENERATOR.PATTERN.toCharArray(), Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONT_LETTER_WIDTH * multiplierX, Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONT_LETTER_HEIGHT * multiplierY, Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONT_OUTLINE, (float)Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONT_OUTLINE_RATE, Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONT_OUTLINE_OFFSET_X * multiplierX, Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONT_OUTLINE_OFFSET_Y * multiplierY, 1.35);
    }

    private BufferedImage resizeIfNeeded(BufferedImage image, int width, int height) {
        if (image.getWidth() != width || image.getHeight() != height) {
            BufferedImage resizedImage = new BufferedImage(width, height, image.getType());
            Graphics2D graphics = resizedImage.createGraphics();
            graphics.drawImage(image.getScaledInstance(width, height, 4), 0, 0, null);
            graphics.dispose();
            return resizedImage;
        }
        return image;
    }

    private void rotate(MapData mapData) {
        byte[] mapImage = mapData.getData();
        byte[] temp = new byte[16384];
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                temp[y * 128 + x] = mapImage[x * 128 + 128 - y - 1];
            }
        }
        System.arraycopy(temp, 0, mapImage, 0, 16384);
    }

    public void generateImages() {
        if (this.shouldStop) {
            return;
        }
        this.shouldStop = true;
        if (this.tempCachedCaptcha != null) {
            this.tempCachedCaptcha.dispose();
        }
        int threadsCount = Runtime.getRuntime().availableProcessors();
        this.tempCachedCaptcha = new CachedCaptcha(this.plugin, threadsCount);
        this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadsCount);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        LinkedList threads = new LinkedList();
        this.executor.setThreadFactory(runnable -> {
            Thread thread = new Thread(threadGroup, runnable, "CaptchaGeneratorThread");
            threads.add(thread);
            thread.setPriority(1);
            return thread;
        });
        for (int i = 0; i < Settings.IMP.MAIN.CAPTCHA_GENERATOR.IMAGES_COUNT; ++i) {
            this.executor.execute(() -> this.genNewPacket(this.tempCachedCaptcha));
        }
        long start = System.currentTimeMillis();
        this.executor.execute(() -> {
            while (this.executor.getCompletedTaskCount() != (long)Settings.IMP.MAIN.CAPTCHA_GENERATOR.IMAGES_COUNT) {
            }
            LimboFilter.getLogger().info("Captcha generated in " + (System.currentTimeMillis() - start) + " ms.");
            if (this.cachedCaptcha != null) {
                this.cachedCaptcha.dispose();
            }
            threads.forEach(arg_0 -> ((LimboFactory)this.plugin.getLimboFactory()).releasePreparedPacketThread(arg_0));
            threads.clear();
            this.cachedCaptcha = this.tempCachedCaptcha;
            this.tempCachedCaptcha = null;
            this.cachedCaptcha.build();
            this.executor.shutdown();
            this.shouldStop = false;
        });
    }

    public void genNewPacket(CachedCaptcha cachedCaptcha) {
        MinecraftPacket[] packets17;
        CraftMapCanvas map;
        Pair<String, String> answer = this.randomAnswer();
        if (this.backplates.isEmpty()) {
            map = this.createCraftMapCanvas();
        } else {
            if (!this.backplatesIterator.get().hasNext()) {
                this.backplatesIterator.set(this.backplates.listIterator());
            }
            map = new CraftMapCanvas(this.backplatesIterator.get().next());
        }
        if (!this.fontIterator.get().hasNext()) {
            this.fontIterator.set(this.fonts.listIterator());
        }
        map.drawImageCraft(this.painter.drawCaptcha(this.fontIterator.get().next(), this.nextColor(), (String)answer.key()), this.painter.getWidth(), this.painter.getHeight());
        map.drawImage(this.painter.drawCurves(), this.painter.getWidth(), this.painter.getHeight());
        Function<MapPalette.MapVersion, MinecraftPacket[]> packet = mapVersion -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            MinecraftPacket[] packets = new MinecraftPacket[map.getWidth() * map.getHeight()];
            for (int mapId = 0; mapId < packets.length; ++mapId) {
                MapData mapData = map.getMapData(mapId, (MapPalette.MapVersion)mapVersion);
                if (Settings.IMP.MAIN.FRAMED_CAPTCHA.FRAMED_CAPTCHA_ENABLED && random.nextDouble() <= Settings.IMP.MAIN.FRAMED_CAPTCHA.FRAME_ROTATION_CHANCE) {
                    for (int j = 0; j < random.nextInt(4); ++j) {
                        this.rotate(mapData);
                    }
                }
                packets[mapId] = (MinecraftPacket)this.plugin.getPacketFactory().createMapDataPacket(mapId, (byte)0, mapData);
            }
            return packets;
        };
        if (this.plugin.getLimboFactory().getPrepareMinVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_7_6) <= 0) {
            int mapCount = map.getWidth() * map.getHeight();
            packets17 = new MinecraftPacket[128 * mapCount];
            for (int mapId = 0; mapId < mapCount; ++mapId) {
                MapData[] maps17Data = map.getMaps17Data(mapId);
                for (int i = 0; i < 128; ++i) {
                    packets17[mapId * 128 + i] = (MinecraftPacket)this.plugin.getPacketFactory().createMapDataPacket(mapId, (byte)0, maps17Data[i]);
                }
            }
        } else {
            packets17 = new MinecraftPacket[]{};
        }
        cachedCaptcha.addCaptchaPacket((String)answer.value(), packets17, packet);
    }

    public void shutdown() {
        this.shouldStop = true;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.tempCachedCaptcha != null) {
            this.tempCachedCaptcha.dispose();
        }
        if (this.cachedCaptcha != null) {
            this.cachedCaptcha.dispose();
        }
    }

    public CaptchaHolder getNextCaptcha() {
        if (this.cachedCaptcha == null) {
            return null;
        }
        return this.cachedCaptcha.getNextCaptcha();
    }

    private String spellNumber(int number) {
        StringBuilder result = new StringBuilder();
        Map<String, String> exceptions = Settings.IMP.MAIN.CAPTCHA_GENERATOR.NUMBER_SPELLING_EXCEPTIONS;
        List<List<String>> words = Settings.IMP.MAIN.CAPTCHA_GENERATOR.NUMBER_SPELLING_WORDS;
        int idx = Settings.IMP.MAIN.CAPTCHA_GENERATOR.LENGTH;
        String n = String.valueOf(number);
        while (!n.isEmpty()) {
            String word;
            if (exceptions.containsKey(n)) {
                result.append(exceptions.get(n)).append(' ');
                break;
            }
            int digit = n.charAt(0) - 48;
            if ((word = words.get(--idx).get(digit)) != null && !word.isBlank()) {
                result.append(word).append(' ');
            }
            n = n.substring(1);
        }
        return result.toString();
    }

    private Pair<String, String> randomAnswer() {
        int length = Settings.IMP.MAIN.CAPTCHA_GENERATOR.LENGTH;
        if (!Settings.IMP.MAIN.CAPTCHA_GENERATOR.NUMBER_SPELLING) {
            String pattern = Settings.IMP.MAIN.CAPTCHA_GENERATOR.PATTERN;
            char[] text = new char[length];
            for (int i = 0; i < length; ++i) {
                text[i] = pattern.charAt(ThreadLocalRandom.current().nextInt(pattern.length()));
            }
            String answer = new String(text);
            return Pair.of((Object)answer, (Object)answer);
        }
        int min = (int)Math.pow(10.0, length - 1);
        int value = ThreadLocalRandom.current().nextInt(min, min * 10);
        return Pair.of((Object)this.spellNumber(value), (Object)String.valueOf(value));
    }

    private byte[] nextColor() {
        if (!this.colorIterator.get().hasNext()) {
            this.colorIterator.set(this.colors.listIterator());
        }
        return this.colorIterator.get().next();
    }
}

