/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.captcha;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import net.elytrium.limboapi.api.protocol.PreparedPacket;

public class CaptchaHolder {
    private final String answer;
    private final MinecraftPacket[] mapDataPackets17;
    private final MinecraftPacket[][] mapDataPacket;
    private final PreparedPacket[] preparedMapPacket;
    private CaptchaHolder next;

    public CaptchaHolder(CaptchaHolder another) {
        this.answer = another.answer;
        this.mapDataPackets17 = another.mapDataPackets17;
        this.mapDataPacket = another.mapDataPacket;
        this.preparedMapPacket = another.preparedMapPacket;
        this.next = another.next;
    }

    public CaptchaHolder(String answer, CaptchaHolder next, MinecraftPacket[] mapDataPackets17, MinecraftPacket[][] mapDataPacket) {
        this.answer = answer;
        this.next = next;
        this.mapDataPackets17 = mapDataPackets17;
        this.mapDataPacket = mapDataPacket;
        this.preparedMapPacket = null;
    }

    public CaptchaHolder(String answer, CaptchaHolder next, PreparedPacket ... preparedMapPacket) {
        this.answer = answer;
        this.next = next;
        this.mapDataPackets17 = null;
        this.mapDataPacket = null;
        this.preparedMapPacket = preparedMapPacket;
    }

    public Object[] getMapPacket(ProtocolVersion version) {
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            return this.mapDataPackets17 == null ? this.preparedMapPacket : this.mapDataPackets17;
        }
        return this.mapDataPacket == null ? this.preparedMapPacket : this.mapDataPacket[version.ordinal()];
    }

    public String getAnswer() {
        return this.answer;
    }

    public CaptchaHolder getNext() {
        return this.next;
    }

    public void setNext(CaptchaHolder next) {
        this.next = next;
    }

    public void release() {
        this.next = null;
        if (this.preparedMapPacket != null) {
            for (PreparedPacket preparedPacket : this.preparedMapPacket) {
                preparedPacket.release();
            }
        }
    }
}

