/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.captcha.map;

import com.velocitypowered.api.network.ProtocolVersion;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import net.elytrium.limboapi.api.protocol.packets.data.MapData;
import net.elytrium.limboapi.api.protocol.packets.data.MapPalette;

public class CraftMapCanvas {
    private final byte[][] canvas;
    private final ThreadLocal<byte[]> buffer17 = ThreadLocal.withInitial(() -> new byte[16384]);
    private final int width;
    private final int height;

    public CraftMapCanvas(int width, int height) {
        this.width = width;
        this.height = height;
        this.canvas = new byte[width * height][16384];
        Arrays.stream(this.canvas).forEach(e -> Arrays.fill(e, (byte)0));
    }

    public CraftMapCanvas(CraftMapCanvas another) {
        this.width = another.width;
        this.height = another.height;
        this.canvas = (byte[][])Arrays.stream(another.getCanvas()).map(rec$ -> (byte[])((byte[])rec$).clone()).toArray(x$0 -> new byte[x$0][]);
    }

    public void drawImage(BufferedImage image, int width, int height) {
        this.drawImageCraft(MapPalette.imageToBytes((BufferedImage)image, (ProtocolVersion)ProtocolVersion.MAXIMUM_VERSION), width, height);
    }

    public void drawImage(int[] image, int width, int height) {
        if (image == null) {
            return;
        }
        this.drawImageCraft(MapPalette.imageToBytes((int[])image, (ProtocolVersion)ProtocolVersion.MAXIMUM_VERSION), width, height);
    }

    public void drawImageCraft(byte[] craftBytes, int width, int height) {
        for (int canvasY = 0; canvasY < this.height; ++canvasY) {
            for (int canvasX = 0; canvasX < this.width; ++canvasX) {
                int canvas = this.canvas.length - 1 - canvasY * this.width - canvasX;
                for (int dataY = 0; dataY < 128; ++dataY) {
                    int imageX;
                    int imageY = canvasY * 128 + dataY;
                    if (imageY >= height) {
                        return;
                    }
                    for (int dataX = 0; dataX < 128 && (imageX = canvasX * 128 + dataX) < width; ++dataX) {
                        byte color = craftBytes[imageY * width + imageX];
                        if (color == 0) continue;
                        this.canvas[canvas][dataY * 128 + dataX] = color;
                    }
                }
            }
        }
    }

    public void drawImageCraft(int[] craftBytes, int width, int height) {
        for (int canvasY = 0; canvasY < this.height; ++canvasY) {
            for (int canvasX = 0; canvasX < this.width; ++canvasX) {
                int canvas = this.canvas.length - 1 - canvasY * this.width - canvasX;
                for (int mapY = 0; mapY < 128; ++mapY) {
                    int imageX;
                    int imageY = canvasY * 128 + mapY;
                    if (imageY >= height) {
                        return;
                    }
                    for (int mapX = 0; mapX < 128 && (imageX = canvasX * 128 + mapX) < width; ++mapX) {
                        byte color = (byte)craftBytes[imageY * width + imageX];
                        if (color == 0) continue;
                        this.canvas[canvas][mapY * 128 + mapX] = color;
                    }
                }
            }
        }
    }

    public MapData getMapData(int index, MapPalette.MapVersion version) {
        byte[] convertedCanvas = new byte[16384];
        return new MapData(MapPalette.convertImage((byte[])this.canvas[index], (byte[])convertedCanvas, (MapPalette.MapVersion)version));
    }

    public MapData[] getMaps17Data(int index) {
        MapData[] maps = new MapData[128];
        byte[] fixedCanvas = this.buffer17.get();
        Arrays.fill(fixedCanvas, (byte)0);
        MapPalette.convertImage((byte[])this.canvas[index], (byte[])fixedCanvas, (MapPalette.MapVersion)MapPalette.MapVersion.MINIMUM_VERSION);
        for (int i = 0; i < 128; ++i) {
            byte[] canvas = new byte[128];
            for (int j = 0; j < 128; ++j) {
                canvas[j] = fixedCanvas[j * 128 + i];
            }
            maps[i] = new MapData(i, canvas);
        }
        return maps;
    }

    public byte[][] getCanvas() {
        return this.canvas;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

