/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.captcha.painter;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.BitSet;
import java.util.concurrent.ThreadLocalRandom;
import net.elytrium.limbofilter.Settings;

public class RenderedFont {
    private final Int2ObjectMap<Glyph> charToGlyph = new Int2ObjectOpenHashMap();

    public RenderedFont(Font font, FontRenderContext ctx, char[] alphabet, int width, int height, boolean outlineEnabled, float outlineMultiplier, int outlineOffsetX, int outlineOffsetY, double zoom) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (char c : alphabet) {
            GlyphVector vector = font.createGlyphVector(ctx, String.valueOf(c));
            if (Settings.IMP.MAIN.CAPTCHA_GENERATOR.FONT_ROTATE) {
                vector.setGlyphTransform(0, AffineTransform.getRotateInstance((random.nextDouble() - 0.5) * Math.PI / 8.0));
            }
            Point2D pos = vector.getGlyphPosition(0);
            double posX = pos.getX();
            double posY = pos.getY();
            Rectangle2D bounds = vector.getGlyphVisualBounds(0).getBounds2D();
            vector.setGlyphPosition(0, new Point2D.Double(posX - bounds.getX(), posY));
            BitSet glyphArray = new BitSet(width * height);
            Shape shape = vector.getGlyphOutline(0, -((float)width) * 1.25f, -((float)height) * 0.3125f);
            this.drawShape(shape, glyphArray, width, height, 0, 0, zoom);
            if (outlineEnabled) {
                BasicStroke stroke = new BasicStroke(outlineMultiplier);
                this.drawShape(stroke.createStrokedShape(shape), glyphArray, width, height, outlineOffsetX, outlineOffsetY, zoom);
            }
            this.charToGlyph.put((int)c, (Object)new Glyph(glyphArray, width, height));
        }
    }

    private void drawShape(Shape shape, BitSet array, int width, int height, int offsetX, int offsetY, double zoom) {
        Rectangle2D box = shape.getBounds2D();
        double multiplierX = box.getX() / (double)width * zoom;
        double multiplierY = box.getY() / (double)height * zoom;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int index;
                if (!shape.contains(multiplierX * (double)x, multiplierY * (double)y) || (index = (height - y - 1 + offsetY) * width + (width - x - 1 + offsetX)) < 0 || index >= array.size()) continue;
                array.set(index);
            }
        }
    }

    public Glyph getGlyph(char charToGet) {
        return (Glyph)this.charToGlyph.get((int)charToGet);
    }

    public static class Glyph {
        private final BitSet glyphData;
        private final int width;
        private final int height;

        public Glyph(BitSet glyphData, int width, int height) {
            this.glyphData = glyphData;
            this.width = width;
            this.height = height;
        }

        public BitSet getGlyphData() {
            return this.glyphData;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

