/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.captcha.painter;

import net.elytrium.limbofilter.captcha.painter.CaptchaEffect;

public class RippleEffect
implements CaptchaEffect {
    private final int[] verticalDelta;
    private final int[] horizontalDelta;

    public RippleEffect(AxisConfig vertical, AxisConfig horizontal, int width, int height) {
        this.verticalDelta = this.calcDeltaArray(vertical, width);
        this.horizontalDelta = this.calcDeltaArray(horizontal, height);
    }

    @Override
    public void filter(int width, int height, byte[] src, byte[] dest) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int ny = (y + this.verticalDelta[x] + height) % height;
                int nx = (x + this.horizontalDelta[ny] + width) % width;
                dest[ny * width + nx] = src[y * width + x];
            }
        }
    }

    protected int[] calcDeltaArray(AxisConfig axisConfig, int num) {
        int[] delta = new int[num];
        double start = axisConfig.getStart();
        double period = axisConfig.getLength() / (double)num;
        double amplitude = axisConfig.getAmplitude();
        for (int i = 0; i < num; ++i) {
            delta[i] = (int)Math.round(amplitude * Math.sin(start + (double)i * period));
        }
        return delta;
    }

    @Override
    public boolean shouldCopy() {
        return true;
    }

    public static class AxisConfig {
        private final double start;
        private final double length;
        private final double amplitude;

        public AxisConfig(double start, double length, double amplitude) {
            this.start = this.normalize(start, 2);
            this.length = this.normalize(length, 4);
            this.amplitude = amplitude;
        }

        protected double normalize(double a, int multi) {
            double piMulti = (double)multi * Math.PI;
            a = Math.abs(a);
            return a - Math.floor(a / piMulti) * piMulti;
        }

        public double getStart() {
            return this.start;
        }

        public double getLength() {
            return this.length;
        }

        public double getAmplitude() {
            return this.amplitude;
        }
    }
}

