/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializer;
import net.elytrium.limboapi.thirdparty.commons.velocity.commands.SuggestUtils;
import net.elytrium.limbofilter.LimboFilter;
import net.elytrium.limbofilter.Settings;

public class SendFilterCommand
implements SimpleCommand {
    private final LimboFilter plugin;

    public SendFilterCommand(LimboFilter plugin) {
        this.plugin = plugin;
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        return SuggestUtils.suggestServersAndPlayers((ProxyServer)this.plugin.getServer(), (String[])args, (int)args.length, (String[])new String[0]);
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        ProxyServer server = this.plugin.getServer();
        Serializer serializer = LimboFilter.getSerializer();
        for (String target : args) {
            Optional registeredServer = server.getServer(target);
            if (registeredServer.isPresent()) {
                Collection players = ((RegisteredServer)registeredServer.get()).getPlayersConnected();
                players.forEach(this.plugin::resetCacheForFilterUser);
                players.forEach(this.plugin::sendToFilterServer);
                source.sendMessage(serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.SEND_SERVER_SUCCESSFUL, players.size(), target)));
                continue;
            }
            Optional optionalPlayer = server.getPlayer(target);
            if (optionalPlayer.isPresent()) {
                Player player = (Player)optionalPlayer.get();
                this.plugin.resetCacheForFilterUser(player);
                this.plugin.sendToFilterServer(player);
                source.sendMessage(serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.SEND_PLAYER_SUCCESSFUL, player.getUsername())));
                continue;
            }
            source.sendMessage(serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.SEND_FAILED, target)));
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return Settings.IMP.MAIN.COMMAND_PERMISSION_STATE.SEND_FILTER.hasPermission((PermissionSubject)invocation.source(), "limbofilter.admin.sendfilter");
    }
}

