/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.listener;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.event.query.ProxyQueryEvent;
import com.velocitypowered.api.proxy.Player;
import java.net.InetSocketAddress;
import net.elytrium.limboapi.api.event.LoginLimboRegisterEvent;
import net.elytrium.limbofilter.LimboFilter;
import net.elytrium.limbofilter.Settings;
import net.elytrium.limbofilter.stats.Statistics;

public class FilterListener {
    private final LimboFilter plugin;

    public FilterListener(LimboFilter plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onProxyConnect(PreLoginEvent event) {
        this.plugin.getStatistics().addConnection();
        if (this.plugin.checkCpsLimit(Settings.IMP.MAIN.FILTER_AUTO_TOGGLE.ONLINE_MODE_VERIFY) && this.plugin.shouldCheck(event.getUsername(), event.getConnection().getRemoteAddress().getAddress())) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
        }
    }

    @Subscribe
    public void onProxyDisconnect(DisconnectEvent event) {
        Statistics statistics;
        InetSocketAddress address = event.getPlayer().getRemoteAddress();
        if (address != null && (statistics = this.plugin.getStatistics()) != null) {
            statistics.removeAddress(address.getAddress());
        }
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onLogin(LoginLimboRegisterEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.shouldCheck(player)) {
            event.addOnJoinCallback(() -> this.plugin.sendToFilterServer(player));
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPing(ProxyPingEvent event) {
        if (this.plugin.checkPpsLimit(Settings.IMP.MAIN.FILTER_AUTO_TOGGLE.DISABLE_MOTD_PICTURE)) {
            event.setPing(event.getPing().asBuilder().clearFavicon().build());
        }
        this.plugin.getStatistics().addPing();
    }

    @Subscribe
    public void onQuery(ProxyQueryEvent event) {
        this.plugin.getStatistics().addConnection();
    }
}

