/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.listener;

import com.velocitypowered.proxy.config.VelocityConfiguration;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.elytrium.limbofilter.LimboFilter;
import net.elytrium.limbofilter.Settings;
import net.elytrium.pcap.Pcap;
import net.elytrium.pcap.PcapException;
import net.elytrium.pcap.data.PcapAddress;
import net.elytrium.pcap.data.PcapDevice;
import net.elytrium.pcap.data.PcapError;
import net.elytrium.pcap.handle.BpfProgram;
import net.elytrium.pcap.handle.PcapHandle;
import net.elytrium.pcap.layer.IP;
import net.elytrium.pcap.layer.Packet;
import net.elytrium.pcap.layer.TCP;
import net.elytrium.pcap.layer.data.LinkType;
import net.elytrium.pcap.layer.exception.LayerDecodeException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class TcpListener {
    private final LimboFilter plugin;
    private final Map<InetAddress, TcpAwaitingPacket> tempPingTimestamp = new HashMap<InetAddress, TcpAwaitingPacket>();
    private @MonotonicNonNull PcapHandle handle;

    public TcpListener(LimboFilter plugin) {
        this.plugin = plugin;
    }

    public void start() throws PcapException {
        this.handle = Pcap.openLive(Settings.IMP.MAIN.TCP_LISTENER.INTERFACE_NAME, Settings.IMP.MAIN.TCP_LISTENER.SNAPLEN, 1, Settings.IMP.MAIN.TCP_LISTENER.TIMEOUT);
        int port = ((VelocityConfiguration)this.plugin.getServer().getConfiguration()).getBind().getPort();
        BpfProgram filter = this.handle.compile("tcp and (dst port " + port + " or src port " + port + ")", 1);
        this.handle.setFilter(filter);
        filter.free();
        Set localAddresses = Pcap.findAllDevs().stream().map(PcapDevice::getAddresses).flatMap(Collection::stream).map(PcapAddress::getAddress).filter(Objects::nonNull).map(InetSocketAddress::getAddress).collect(Collectors.toSet());
        LinkType datalink = this.handle.datalink();
        new Thread(() -> {
            block2: {
                Thread.currentThread().setContextClassLoader(LimboFilter.class.getClassLoader());
                long listenDelay = Settings.IMP.MAIN.TCP_LISTENER.LISTEN_DELAY;
                try {
                    this.handle.loop(-1, (packetHeader, rawPacket) -> {
                        try {
                            int pingDiff;
                            TcpAwaitingPacket awaitingPacket;
                            long currentTime;
                            TcpAwaitingPacket previousPacket;
                            Packet packet = new Packet();
                            packet.decode(rawPacket, datalink);
                            IP ipPacket = (IP)packet.getLayers().get(1);
                            TCP tcpPacket = (TCP)packet.getLayers().get(2);
                            if (localAddresses.contains(ipPacket.getSrcAddress()) && tcpPacket.isPsh() && tcpPacket.isAck() && (previousPacket = this.tempPingTimestamp.get(ipPacket.getDstAddress())) != null && previousPacket.time + listenDelay <= (currentTime = System.currentTimeMillis())) {
                                previousPacket.seq = tcpPacket.getAckSn();
                                previousPacket.time = currentTime;
                            }
                            if (localAddresses.contains(ipPacket.getDstAddress()) && tcpPacket.isAck() && (awaitingPacket = this.tempPingTimestamp.get(ipPacket.getSrcAddress())) != null && awaitingPacket.seq == tcpPacket.getSequence() && (pingDiff = (int)(System.currentTimeMillis() - awaitingPacket.time)) > 2) {
                                this.plugin.getStatistics().updatePing(ipPacket.getSrcAddress(), pingDiff);
                            }
                        }
                        catch (LayerDecodeException e) {
                            throw new IllegalStateException(e);
                        }
                    });
                }
                catch (PcapException e) {
                    if (e.getError() == PcapError.ERROR_BREAK) break block2;
                    throw new IllegalStateException(e);
                }
            }
        }).start();
    }

    public void registerAddress(InetAddress address) {
        this.tempPingTimestamp.put(address, new TcpAwaitingPacket(Integer.MIN_VALUE, 0L));
    }

    public void removeAddress(InetAddress address) {
        this.tempPingTimestamp.remove(address);
    }

    public void stop() {
        this.handle.breakLoop();
        this.handle.close();
    }

    static {
        try {
            Pcap.init();
        }
        catch (PcapException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class TcpAwaitingPacket {
        private int seq;
        private long time;

        private TcpAwaitingPacket(int seq, long time) {
            this.seq = seq;
            this.time = time;
        }
    }
}

