/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.stats;

import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.Scheduler;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import net.elytrium.limbofilter.LimboFilter;
import net.elytrium.limbofilter.Settings;

public class Statistics {
    private final LongAdder blockedConnections = new LongAdder();
    private final LongAdder connections = new LongAdder();
    private final LongAdder pings = new LongAdder();
    private final AtomicLong interpolatedCpsBefore = new AtomicLong();
    private final AtomicLong interpolatedPpsBefore = new AtomicLong();
    private final List<ScheduledTask> scheduledTaskList = new LinkedList<ScheduledTask>();
    private final Map<InetAddress, Integer> pingMap = new HashMap<InetAddress, Integer>();

    public void addBlockedConnection() {
        this.blockedConnections.increment();
    }

    public void addConnection() {
        this.connections.add((long)Settings.IMP.MAIN.UNIT_OF_TIME_CPS * 2L);
    }

    public void addPing() {
        this.pings.add((long)Settings.IMP.MAIN.UNIT_OF_TIME_CPS * 2L);
    }

    public long getBlockedConnections() {
        return this.blockedConnections.longValue();
    }

    public long getConnections() {
        return this.connections.longValue() / (long)Settings.IMP.MAIN.UNIT_OF_TIME_CPS / 2L;
    }

    public long getPings() {
        return this.pings.longValue() / (long)Settings.IMP.MAIN.UNIT_OF_TIME_CPS / 2L;
    }

    public long getTotalConnection() {
        return this.getPings() + this.getConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartUpdateTasks(LimboFilter plugin, Scheduler scheduler) {
        List<ScheduledTask> list = this.scheduledTaskList;
        synchronized (list) {
            this.scheduledTaskList.forEach(ScheduledTask::cancel);
            this.scheduledTaskList.clear();
            this.startUpdatingCps(plugin, scheduler);
            this.startUpdatingPps(plugin, scheduler);
        }
    }

    private void startUpdatingCps(LimboFilter plugin, Scheduler scheduler) {
        long delayInterpolate = (long)Settings.IMP.MAIN.UNIT_OF_TIME_CPS * 1000L;
        this.scheduledTaskList.add(scheduler.buildTask((Object)plugin, () -> this.interpolatedCpsBefore.set(this.connections.longValue() / (long)Settings.IMP.MAIN.UNIT_OF_TIME_CPS / 2L)).delay(delayInterpolate, TimeUnit.MILLISECONDS).repeat(delayInterpolate, TimeUnit.MILLISECONDS).schedule());
        long delay = delayInterpolate / (long)Settings.IMP.MAIN.UNIT_OF_TIME_CPS / 2L;
        this.scheduledTaskList.add(scheduler.buildTask((Object)plugin, () -> {
            long before;
            long current = this.connections.longValue();
            if (current >= (before = this.interpolatedCpsBefore.get())) {
                this.connections.add(-before);
            }
        }).delay(delay, TimeUnit.MILLISECONDS).repeat(delay, TimeUnit.MILLISECONDS).schedule());
    }

    private void startUpdatingPps(LimboFilter plugin, Scheduler scheduler) {
        long delayInterpolate = (long)Settings.IMP.MAIN.UNIT_OF_TIME_PPS * 1000L;
        this.scheduledTaskList.add(scheduler.buildTask((Object)plugin, () -> this.interpolatedPpsBefore.set(this.pings.longValue() / (long)Settings.IMP.MAIN.UNIT_OF_TIME_PPS / 2L)).delay(delayInterpolate, TimeUnit.MILLISECONDS).repeat(delayInterpolate, TimeUnit.MILLISECONDS).schedule());
        long delay = delayInterpolate / (long)Settings.IMP.MAIN.UNIT_OF_TIME_PPS / 2L;
        this.scheduledTaskList.add(scheduler.buildTask((Object)plugin, () -> {
            long before;
            long current = this.pings.longValue();
            if (current >= (before = this.interpolatedPpsBefore.get())) {
                this.pings.add(-before);
            }
        }).delay(delay, TimeUnit.MILLISECONDS).repeat(delay, TimeUnit.MILLISECONDS).schedule());
    }

    public void updatePing(InetAddress address, int currentPing) {
        this.pingMap.merge(address, currentPing, (previousPing, newPing) -> (previousPing * 3 + newPing) / 4);
    }

    public int getPing(InetAddress address) {
        Integer ping = this.pingMap.get(address);
        if (ping == null) {
            return -1;
        }
        return ping;
    }

    public void removeAddress(InetAddress address) {
        this.pingMap.remove(address);
    }
}

