/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.elytrium.pcap.PcapHandler;

public class PcapNative {
    public static native boolean isJavaCritical();

    public static native String getErrorBuffer();

    public static native String init();

    public static native int lookupnet(String var0, int[] var1);

    public static native long create(String var0);

    public static native String getError(long var0);

    public static native int activate(long var0);

    public static native long findAllDevs();

    public static native void freeAllDevs(long var0);

    public static native long openLive(String var0, int var1, int var2, int var3);

    public static native long openOffline(String var0);

    public static native long openOfflineWithTstampPrecision(String var0, int var1);

    public static native long openDead(int var0, int var1);

    public static native long openDeadWithTstampPrecision(int var0, int var1, int var2);

    public static native void close(long var0);

    public static native int setSnaplen(long var0, int var2);

    public static native int snapshot(long var0);

    public static native int setPromisc(long var0, int var2);

    public static native int setProtocolLinux(long var0, int var2);

    public static native int setRfmon(long var0, int var2);

    public static native int canSetRfmon(long var0);

    public static native int setTimeout(long var0, int var2);

    public static native int setImmediateMode(long var0, int var2);

    public static native int setBufferSize(long var0, int var2);

    public static native int setTstampType(long var0, int var2);

    public static native long listTstampTypes(long var0, int[] var2);

    public static native void freeTstampTypes(long var0);

    public static native String tstampTypeValToName(int var0);

    public static native String tstampTypeValToDescription(int var0);

    public static native int tstampTypeNameToVal(String var0);

    public static native int setTstampPrecision(long var0, int var2);

    public static native int getTstampPrecision(long var0);

    public static native int datalink(long var0);

    public static native int file(long var0);

    public static native int isSwapped(long var0);

    public static native int majorVersion(long var0);

    public static native int minorVersion(long var0);

    public static native long listDatalinks(long var0, int[] var2);

    public static native void freeDatalinks(long var0);

    public static native int loop(long var0, int var2, PcapHandler var3);

    public static native int dispatch(long var0, int var2, PcapHandler var3);

    public static native int next(long var0, long[] var2, ByteBuffer[] var3);

    public static native void breakLoop(long var0);

    public static native int stats(long var0, long var2);

    public static native int setFilter(long var0, long var2);

    public static native int setDirection(long var0, int var2);

    public static native int getNonBlock(long var0);

    public static native int setNonBlock(long var0, int var2);

    public static native int inject(long var0, ByteBuffer var2);

    public static native int sendPacket(long var0, ByteBuffer var2);

    public static native String statusToString(int var0);

    public static native String stringError(int var0);

    public static native String stringErrorErrno();

    public static native int compile(long var0, long var2, String var4, int var5, int var6);

    public static native void freeCode(long var0);

    public static native int offlineFilter(long var0, long var2, ByteBuffer var4);

    public static native int setDatalink(long var0, int var2);

    public static native int datalinkNameToVal(String var0);

    public static native String datalinkValToName(int var0);

    public static native String datalinkValToDescription(int var0);

    public static native String datalinkValToDescriptionOrDlt(int var0);

    public static native int fileno(long var0);

    public static native long dumpOpen(long var0, String var2);

    public static native long dumpOpenAppend(long var0, String var2);

    public static native long dumpFtell(long var0);

    public static native int dumpFlush(long var0);

    public static native void dumpClose(long var0);

    public static native void dump(long var0, long var2, ByteBuffer var4);

    public static native String libVersion();

    static {
        try {
            System.loadLibrary("pcap-native");
        }
        catch (UnsatisfiedLinkError e) {
            try (InputStream inputStream = PcapNative.class.getResourceAsStream("/libpcap-native.so");){
                if (inputStream == null) {
                    throw new IOException();
                }
                File directory = Files.createTempDirectory("pcap-native", new FileAttribute[0]).toFile();
                File libraryFile = new File(directory, "libpcap-native.so");
                Files.copy(inputStream, libraryFile.toPath(), new CopyOption[0]);
                System.load(libraryFile.getAbsolutePath());
                libraryFile.deleteOnExit();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw e;
            }
        }
    }
}

