/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.data;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.elytrium.pcap.data.PcapPacketHeader;

public class PcapRawPacket {
    private final PcapPacketHeader header;
    private final ByteBuffer byteBuffer;

    public PcapRawPacket(PcapPacketHeader header, ByteBuffer byteBuffer) {
        this.header = header;
        this.byteBuffer = byteBuffer;
    }

    public PcapPacketHeader getHeader() {
        return this.header;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PcapRawPacket that = (PcapRawPacket)o;
        if (!Objects.equals(this.header, that.header)) {
            return false;
        }
        return Objects.equals(this.byteBuffer, that.byteBuffer);
    }

    public int hashCode() {
        int result = this.header != null ? this.header.hashCode() : 0;
        result = 31 * result + (this.byteBuffer != null ? this.byteBuffer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PcapRawPacket{header=" + this.header + ", byteBuffer=" + this.byteBuffer + '}';
    }
}

