/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.data;

import net.elytrium.pcap.memory.MemoryReader;

public class PcapStat {
    private final int packetsReceived;
    private final int packetsDropped;
    private final int interfaceDrops;

    public PcapStat(int packetsReceived, int packetsDropped, int interfaceDrops) {
        this.packetsReceived = packetsReceived;
        this.packetsDropped = packetsDropped;
        this.interfaceDrops = interfaceDrops;
    }

    public int getPacketsReceived() {
        return this.packetsReceived;
    }

    public int getPacketsDropped() {
        return this.packetsDropped;
    }

    public int getInterfaceDrops() {
        return this.interfaceDrops;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PcapStat pcapStat = (PcapStat)o;
        if (this.packetsReceived != pcapStat.packetsReceived) {
            return false;
        }
        if (this.packetsDropped != pcapStat.packetsDropped) {
            return false;
        }
        return this.interfaceDrops == pcapStat.interfaceDrops;
    }

    public int hashCode() {
        int result = this.packetsReceived;
        result = 31 * result + this.packetsDropped;
        result = 31 * result + this.interfaceDrops;
        return result;
    }

    public String toString() {
        return "PcapStat{packetsReceived=" + this.packetsReceived + ", packetsDropped=" + this.packetsDropped + ", interfaceDrops=" + this.interfaceDrops + '}';
    }

    public static PcapStat read(long address) {
        if (address == 0L) {
            return null;
        }
        MemoryReader reader = new MemoryReader(address);
        return new PcapStat(reader.readInt(), reader.readInt(), reader.readInt());
    }
}

