/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.handle;

import java.nio.ByteBuffer;
import net.elytrium.pcap.PcapException;
import net.elytrium.pcap.PcapNative;
import net.elytrium.pcap.data.PcapError;
import net.elytrium.pcap.data.PcapPacketHeader;

public class PcapDumper {
    private final long address;

    public PcapDumper(long address) {
        this.address = address;
    }

    public long getAddress() {
        return this.address;
    }

    public long ftell() throws PcapException {
        long position = PcapNative.dumpFtell(this.address);
        if (position < 0L) {
            PcapError.throwIfNotSuccess((int)position);
        }
        return position;
    }

    public void flush() throws PcapException {
        PcapError.throwIfNotSuccess(PcapNative.dumpFlush(this.address));
    }

    public void close() {
        PcapNative.dumpClose(this.address);
    }

    public void dump(PcapPacketHeader header, ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Only direct buffers are supported.");
        }
        PcapNative.dump(this.address, header.getAddress(), buffer);
    }
}

