/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import net.elytrium.pcap.layer.EthernetProtocolHeader;
import net.elytrium.pcap.layer.Layer;
import net.elytrium.pcap.layer.data.EthernetProtocol;
import net.elytrium.pcap.layer.exception.LayerDecodeException;
import net.elytrium.pcap.layer.exception.LayerEncodeException;

public class Ethernet
implements EthernetProtocolHeader {
    private static final int SIZE = 14;
    private byte[] dstAddress;
    private byte[] srcAddress;
    private EthernetProtocol protocol;

    @Override
    public void decode(ByteBuffer buffer) throws LayerDecodeException {
        if (buffer.remaining() < 14) {
            throw new LayerDecodeException("Ethernet frame is too small.");
        }
        this.dstAddress = new byte[6];
        buffer.get(this.dstAddress);
        this.srcAddress = new byte[6];
        buffer.get(this.srcAddress);
        int protocol = Short.toUnsignedInt(buffer.getShort());
        this.protocol = EthernetProtocol.getByValue(protocol);
    }

    @Override
    public void encode(ByteBuffer buffer) throws LayerEncodeException {
        if (buffer.remaining() < 14) {
            throw new LayerEncodeException("ByteBuffer is too small.");
        }
        buffer.put(this.dstAddress);
        buffer.put(this.srcAddress);
        buffer.putShort((short)this.protocol.getValue());
    }

    @Override
    public int getSize() {
        return 14;
    }

    @Override
    public Supplier<Layer> nextLayer() {
        return this.protocol != null ? this.protocol.getLayer() : null;
    }

    public byte[] getDstAddress() {
        return this.dstAddress;
    }

    public void setDstAddress(byte[] dstAddress) {
        this.dstAddress = dstAddress;
    }

    public byte[] getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(byte[] srcAddress) {
        this.srcAddress = srcAddress;
    }

    @Override
    public EthernetProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(EthernetProtocol protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "Ethernet{dstAddress=" + Arrays.toString(this.dstAddress) + ", srcAddress=" + Arrays.toString(this.srcAddress) + ", protocol=" + (Object)((Object)this.protocol) + '}';
    }
}

