/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.elytrium.pcap.layer.IPv6Header;
import net.elytrium.pcap.layer.data.IpProtocol;
import net.elytrium.pcap.layer.exception.LayerDecodeException;
import net.elytrium.pcap.layer.exception.LayerEncodeException;

public class IPv6ExtOptions
extends IPv6Header {
    protected int headerExtLength;
    protected Map<Integer, byte[]> options;

    @Override
    public void decode(ByteBuffer buffer) throws LayerDecodeException {
        if (buffer.remaining() < 8) {
            throw new LayerDecodeException("Hop-by-hop extension header is too small.");
        }
        int position = buffer.position();
        this.nextHeader = IpProtocol.values()[Byte.toUnsignedInt(buffer.get())];
        this.headerExtLength = Byte.toUnsignedInt(buffer.get());
        if (buffer.limit() < (position += 8 + this.headerExtLength * 8)) {
            throw new LayerDecodeException("Invalid hop-by-hop extension header.");
        }
        this.options = new LinkedHashMap<Integer, byte[]>();
        while (buffer.position() < position) {
            if (position - buffer.position() < 2) {
                buffer.position(position);
                break;
            }
            int type = Byte.toUnsignedInt(buffer.get());
            int length = Byte.toUnsignedInt(buffer.get());
            byte[] value = new byte[length];
            buffer.get(value);
            this.options.put(type, value);
        }
    }

    @Override
    public void encode(ByteBuffer buffer) throws LayerEncodeException {
        int size = this.getSize();
        if (buffer.remaining() < size) {
            throw new LayerEncodeException("ByteBuffer is too small.");
        }
        int position = buffer.position() + size;
        buffer.put((byte)this.nextHeader.ordinal());
        buffer.put((byte)this.headerExtLength);
        this.options.forEach((id, value) -> {
            buffer.put(id.byteValue());
            buffer.put((byte)((byte[])value).length);
            buffer.put((byte[])value);
        });
        buffer.put(new byte[position - buffer.position()]);
    }

    @Override
    public int getSize() {
        int optionsSize = this.options.values().stream().mapToInt(value -> 2 + ((byte[])value).length).sum();
        return 2 + optionsSize + 7 & 0xFFFFFFF8;
    }

    public int getHeaderExtLength() {
        return this.headerExtLength;
    }

    public void setHeaderExtLength(int headerExtLength) {
        this.headerExtLength = headerExtLength;
    }

    public Map<Integer, byte[]> getOptions() {
        return this.options;
    }

    public void setOptions(Map<Integer, byte[]> options) {
        this.options = options;
    }

    @Override
    public String toString() {
        return "IPv6ExtOptions{headerExtLength=" + this.headerExtLength + ", options=" + this.options + ", nextHeader=" + (Object)((Object)this.nextHeader) + '}';
    }
}

