/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.pcap.layer;

import java.nio.ByteBuffer;
import net.elytrium.pcap.layer.IPv6Header;
import net.elytrium.pcap.layer.data.IpProtocol;
import net.elytrium.pcap.layer.exception.LayerDecodeException;
import net.elytrium.pcap.layer.exception.LayerEncodeException;

public class IPv6Fragment
extends IPv6Header {
    private static final int SIZE = 8;
    private short fragmentOffset;
    private boolean hasMore;
    private int identification;

    @Override
    public void decode(ByteBuffer buffer) throws LayerDecodeException {
        if (buffer.remaining() < 8) {
            throw new LayerDecodeException("Fragment extension header is too small.");
        }
        this.nextHeader = IpProtocol.values()[Byte.toUnsignedInt(buffer.get())];
        buffer.get();
        short offsetMore = buffer.getShort();
        this.fragmentOffset = (short)(offsetMore >>> 3 & 0x1FFF);
        this.hasMore = (offsetMore & 1) != 0;
        this.identification = buffer.getInt();
    }

    @Override
    public void encode(ByteBuffer buffer) throws LayerEncodeException {
        if (buffer.remaining() < 8) {
            throw new LayerEncodeException("ByteBuffer is too small.");
        }
        buffer.put((byte)this.nextHeader.ordinal());
        buffer.put((byte)0);
        short offsetMore = (short)(this.fragmentOffset << 3);
        offsetMore = (short)(offsetMore | (this.hasMore ? (short)1 : 0));
        buffer.putShort(offsetMore);
        buffer.putInt(this.identification);
    }

    @Override
    public int getSize() {
        return 8;
    }

    public short getFragmentOffset() {
        return this.fragmentOffset;
    }

    public void setFragmentOffset(short fragmentOffset) {
        this.fragmentOffset = fragmentOffset;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    public int getIdentification() {
        return this.identification;
    }

    public void setIdentification(int identification) {
        this.identification = identification;
    }

    @Override
    public String toString() {
        return "Fragment{fragmentOffset=" + this.fragmentOffset + ", hasMore=" + this.hasMore + ", identification=" + this.identification + ", nextHeader=" + (Object)((Object)this.nextHeader) + '}';
    }
}

