package me.hsgamer.topper.fabric.provider;

import me.hsgamer.topper.value.core.ValueProvider;
import me.hsgamer.topper.value.core.ValueWrapper;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3448;
import net.minecraft.class_3469;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public record StatisticValueProvider(String type,
                                     List<String> names) implements ValueProvider<class_3222, Double> {
    @SuppressWarnings({"unchecked", "rawtypes"})
    @Override
    public @NotNull ValueWrapper<Double> apply(@NotNull class_3222 key) {
        class_3469 statHandler = key.method_14248();

        class_2960 typeIdentifier = class_2960.method_12829(type);
        if (typeIdentifier == null) {
            return ValueWrapper.notHandled();
        }

        class_3448 statType = class_7923.field_41193.method_63535(typeIdentifier);
        if (statType == null) {
            return ValueWrapper.notHandled();
        }
        class_2378 statRegistry = statType.method_14959();

        Stream<Object> itemStream = names.isEmpty() ? statRegistry.method_10220() : names.stream()
                .map(class_2960::method_12829)
                .filter(Objects::nonNull)
                .map(statRegistry::method_63535)
                .filter(Objects::nonNull);
        return ValueWrapper.handled(
                itemStream
                        .mapToDouble(item -> statHandler.method_15024(statType, item))
                        .sum()
        );
    }
}
