/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.hook.paper;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class PaperNameCache
implements Function<UUID, String> {
    private static final Function<UUID, Optional<?>> GET_PROFILE_FUNCTION;
    private static final Function<Object, String> GET_NAME_FROM_PROFILE_FUNCTION;

    public static boolean isAvailable() {
        return GET_PROFILE_FUNCTION != null && GET_NAME_FROM_PROFILE_FUNCTION != null;
    }

    @Override
    public String apply(UUID uuid) {
        if (!PaperNameCache.isAvailable()) {
            return null;
        }
        Optional<?> optionalProfile = GET_PROFILE_FUNCTION.apply(uuid);
        if (!optionalProfile.isPresent()) {
            return null;
        }
        Object profile = optionalProfile.get();
        String name = GET_NAME_FROM_PROFILE_FUNCTION.apply(profile);
        return name != null && !name.isEmpty() ? name : null;
    }

    static {
        Function<UUID, Optional> getProfileFunction;
        Function<Object, String> getNameFromProfileFunction;
        try {
            Object nameToIdCache;
            Server server = Bukkit.getServer();
            Class<?> serverClass = server.getClass();
            Method getDedicatedServerMethod = serverClass.getMethod("getServer", new Class[0]);
            Object dedicatedServer = getDedicatedServerMethod.invoke((Object)server, new Object[0]);
            Class<?> dedicatedServerClass = dedicatedServer.getClass();
            try {
                Method servicesMethod = dedicatedServerClass.getMethod("services", new Class[0]);
                Object services = servicesMethod.invoke(dedicatedServer, new Object[0]);
                Class<?> serviceClass = services.getClass();
                Method nameToIdCacheMethod = serviceClass.getMethod("nameToIdCache", new Class[0]);
                nameToIdCache = nameToIdCacheMethod.invoke(services, new Object[0]);
                Class<?> nameAndIdClass = Class.forName("net.minecraft.server.players.NameAndId");
                Method nameMethod = nameAndIdClass.getMethod("name", new Class[0]);
                getNameFromProfileFunction = profile -> {
                    try {
                        Object name = nameMethod.invoke(profile, new Object[0]);
                        if (name instanceof String) {
                            return (String)name;
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        return null;
                    }
                };
            }
            catch (Throwable e) {
                Method nameToIdCacheMethod = dedicatedServerClass.getMethod("getProfileCache", new Class[0]);
                nameToIdCache = nameToIdCacheMethod.invoke(dedicatedServer, new Object[0]);
                Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
                Method getNameMethod = gameProfileClass.getMethod("getName", new Class[0]);
                getNameFromProfileFunction = profile -> {
                    try {
                        Object name = getNameMethod.invoke(profile, new Object[0]);
                        if (name instanceof String) {
                            return (String)name;
                        }
                        return null;
                    }
                    catch (Throwable ignored) {
                        return null;
                    }
                };
            }
            Object finalNameToIdCache = nameToIdCache;
            Class<?> nameToIdCacheClass = nameToIdCache.getClass();
            Method getByIdMethod = nameToIdCacheClass.getMethod("get", UUID.class);
            getProfileFunction = uuid -> {
                try {
                    Object optionalProfile = getByIdMethod.invoke(finalNameToIdCache, uuid);
                    if (optionalProfile instanceof Optional) {
                        return (Optional)optionalProfile;
                    }
                    return Optional.empty();
                }
                catch (Throwable e) {
                    return Optional.empty();
                }
            };
        }
        catch (Throwable ignored) {
            getProfileFunction = null;
            getNameFromProfileFunction = null;
        }
        GET_PROFILE_FUNCTION = getProfileFunction;
        GET_NAME_FROM_PROFILE_FUNCTION = getNameFromProfileFunction;
    }
}

