/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.config.annotation.converter.impl;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import me.hsgamer.topper.spigot.plugin.lib.core.config.annotation.converter.Converter;
import me.hsgamer.topper.spigot.plugin.lib.core.config.annotation.converter.ConverterProvider;

public class EnumConverterProvider
implements ConverterProvider {
    @Override
    public Optional<Converter> getConverter(final Class<?> type) {
        if (!type.isEnum()) {
            return Optional.empty();
        }
        return Optional.of(new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                String rawValue = Objects.toString(raw).toUpperCase(Locale.ROOT);
                try {
                    return Enum.valueOf(type, rawValue);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                if (value == null) {
                    return null;
                }
                if (value instanceof Enum) {
                    return ((Enum)value).name();
                }
                return null;
            }
        });
    }
}

