/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.agent.storage;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.LogLevel;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.Logger;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.provider.LoggerProvider;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.Agent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.data.core.DataEntry;
import me.hsgamer.topper.spigot.plugin.lib.topper.data.core.DataHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.core.DataStorage;
import org.jetbrains.annotations.Nullable;

public class StorageAgent<K, V>
implements Agent,
DataEntryAgent<K, V>,
Runnable {
    private static final Logger LOGGER = LoggerProvider.getLogger(StorageAgent.class);
    private final DataStorage<K, V> storage;
    private final Queue<Map.Entry<K, ValueWrapper<V>>> queue = new ConcurrentLinkedQueue<Map.Entry<K, ValueWrapper<V>>>();
    private final AtomicReference<Map<K, ValueWrapper<V>>> storeMap = new AtomicReference(new ConcurrentHashMap());
    private final AtomicReference<Map<K, ValueWrapper<V>>> savingMap = new AtomicReference();
    private final AtomicBoolean saving = new AtomicBoolean(false);
    private int maxEntryPerCall = 10;
    private boolean loadOnCreate = false;
    private boolean scheduleOnEntryRemove = true;

    public StorageAgent(DataStorage<K, V> storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(boolean urgent) {
        Map.Entry<K, ValueWrapper<V>> entry2;
        if (this.saving.get() && !urgent) {
            return;
        }
        this.saving.set(true);
        ((Map)this.storeMap.getAndSet(new ConcurrentHashMap())).forEach((key, value) -> this.queue.add(new AbstractMap.SimpleEntry<Object, ValueWrapper>(key, (ValueWrapper)value)));
        Map<K, ValueWrapper<ValueWrapper<V>>> map = this.savingMap.updateAndGet(old -> old == null ? new HashMap() : old);
        for (int entryIndex = 0; (urgent || this.maxEntryPerCall <= 0 || entryIndex < this.maxEntryPerCall) && (entry2 = this.queue.poll()) != null; ++entryIndex) {
            map.put(entry2.getKey(), entry2.getValue());
        }
        if (map.isEmpty()) {
            this.savingMap.set(null);
            this.saving.set(false);
            return;
        }
        HashSet removeKeys = new HashSet();
        Map<Object, Object> finalMap = map.entrySet().stream().filter(entry -> {
            Object value = ((ValueWrapper)entry.getValue()).value;
            if (value == null) {
                removeKeys.add(entry.getKey());
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ValueWrapper)entry.getValue()).value));
        Optional<DataStorage.Modifier<K, V>> optionalModifier = this.storage.modify();
        if (!optionalModifier.isPresent()) {
            this.saving.set(false);
            return;
        }
        DataStorage.Modifier<Object, Object> modifier = optionalModifier.get();
        try {
            modifier.save(finalMap);
            if (!removeKeys.isEmpty()) {
                modifier.remove(removeKeys);
            }
            modifier.commit();
            this.savingMap.set(null);
        }
        catch (Throwable t) {
            LOGGER.log(LogLevel.ERROR, "Failed to save entries", t);
            modifier.rollback();
        }
        finally {
            this.saving.set(false);
        }
    }

    protected void scheduleValue(K key, @Nullable V value) {
        this.storeMap.get().put(key, new ValueWrapper(value));
    }

    @Override
    public void start() {
        this.storage.onRegister();
    }

    @Override
    public void stop() {
        this.storage.onUnregister();
    }

    @Override
    public void beforeStop() {
        this.save(true);
    }

    @Override
    public void onCreate(DataEntry<K, V> entry) {
        if (this.loadOnCreate) {
            this.storage.load(entry.getKey()).ifPresent(value -> entry.setValue(value, false));
        }
    }

    @Override
    public void onUpdate(DataEntry<K, V> entry, V oldValue, V newValue) {
        this.scheduleValue(entry.getKey(), Objects.equals(newValue, entry.getHolder().getDefaultValue()) ? null : (V)newValue);
    }

    @Override
    public void onRemove(DataEntry<K, V> entry) {
        if (this.scheduleOnEntryRemove) {
            this.scheduleValue(entry.getKey(), null);
        }
    }

    @Override
    public void run() {
        this.save(false);
    }

    public DataStorage<K, V> getStorage() {
        return this.storage;
    }

    public void setMaxEntryPerCall(int taskSaveEntryPerTick) {
        this.maxEntryPerCall = taskSaveEntryPerTick;
    }

    public void setLoadOnCreate(boolean loadOnCreate) {
        this.loadOnCreate = loadOnCreate;
    }

    public void setScheduleOnEntryRemove(boolean scheduleOnEntryRemove) {
        this.scheduleOnEntryRemove = scheduleOnEntryRemove;
    }

    public Agent getLoadAgent(final DataHolder<K, V> holder) {
        return new Agent(){

            @Override
            public void start() {
                try {
                    StorageAgent.this.storage.load().forEach((uuid, value) -> holder.getOrCreateEntry(uuid).setValue(value, false));
                }
                catch (Exception e) {
                    LOGGER.log(LogLevel.ERROR, "Failed to load entries", e);
                }
            }
        };
    }

    private static final class ValueWrapper<V> {
        @Nullable
        private final V value;

        private ValueWrapper(@Nullable V value) {
            this.value = value;
        }
    }
}

