/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.agent.update;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.update.UpdateStatus;
import me.hsgamer.topper.spigot.plugin.lib.topper.data.core.DataEntry;
import me.hsgamer.topper.spigot.plugin.lib.topper.data.core.DataHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueWrapper;

public class UpdateAgent<K, V>
implements DataEntryAgent<K, V> {
    private final DataHolder<K, V> holder;
    private final Function<K, ValueWrapper<V>> updateFunction;
    private final Map<K, UpdateStatus> map = new ConcurrentHashMap<K, UpdateStatus>();
    private Function<K, FilterResult> filter = null;
    private BiFunction<K, ValueWrapper<V>, ValueWrapper<V>> errorHandler = null;
    private int maxSkips = 1;

    public UpdateAgent(DataHolder<K, V> holder, Function<K, ValueWrapper<V>> updateFunction) {
        this.holder = holder;
        this.updateFunction = updateFunction;
    }

    public void setFilter(Function<K, FilterResult> filter) {
        this.filter = filter;
    }

    public void setErrorHandler(BiFunction<K, ValueWrapper<V>, ValueWrapper<V>> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setErrorHandler(BiConsumer<K, ValueWrapper<V>> errorHandler) {
        this.setErrorHandler((K k, ValueWrapper<V> v) -> {
            errorHandler.accept((Object)k, (ValueWrapper)v);
            return v;
        });
    }

    public void setMaxSkips(int maxSkips) {
        this.maxSkips = maxSkips;
    }

    public Runnable getUpdateRunnable(final int maxEntryPerCall) {
        return new Runnable(){
            private final AtomicReference<Iterator<Map.Entry<K, UpdateStatus>>> iteratorRef = new AtomicReference();

            @Override
            public void run() {
                Iterator iterator = this.iteratorRef.updateAndGet(old -> old == null || !old.hasNext() ? UpdateAgent.this.map.entrySet().iterator() : old);
                int count = 0;
                block9: while (count < maxEntryPerCall && iterator.hasNext()) {
                    Map.Entry entry;
                    try {
                        entry = iterator.next();
                    }
                    catch (Exception e) {
                        break;
                    }
                    Object key = entry.getKey();
                    UpdateStatus updateStatus = entry.getValue();
                    if (updateStatus != UpdateStatus.DEFAULT && !(updateStatus instanceof UpdateStatus.Set)) continue;
                    if (UpdateAgent.this.filter != null) {
                        FilterResult filterResult = (FilterResult)((Object)UpdateAgent.this.filter.apply(key));
                        switch (filterResult.ordinal()) {
                            case 0: {
                                entry.setValue(new UpdateStatus.Skip(UpdateAgent.this.maxSkips));
                                continue block9;
                            }
                            case 1: {
                                entry.setValue(UpdateStatus.RESET);
                                continue block9;
                            }
                        }
                    }
                    ValueWrapper valueWrapper = (ValueWrapper)UpdateAgent.this.updateFunction.apply(key);
                    if (UpdateAgent.this.errorHandler != null && valueWrapper.state == ValueWrapper.State.ERROR) {
                        valueWrapper = (ValueWrapper)UpdateAgent.this.errorHandler.apply(key, valueWrapper);
                    }
                    switch (valueWrapper.state) {
                        case ERROR: 
                        case NOT_HANDLED: {
                            entry.setValue(new UpdateStatus.Skip(UpdateAgent.this.maxSkips));
                            break;
                        }
                        default: {
                            entry.setValue(new UpdateStatus.Set(valueWrapper.value));
                        }
                    }
                    ++count;
                }
            }
        };
    }

    public Runnable getSetRunnable() {
        return () -> {
            Iterator<Map.Entry<K, UpdateStatus>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, UpdateStatus> entry;
                try {
                    entry = iterator.next();
                }
                catch (Exception e) {
                    break;
                }
                Optional<DataEntry<K, V>> optionalDataEntry = this.holder.getEntry(entry.getKey());
                if (!optionalDataEntry.isPresent()) {
                    iterator.remove();
                    continue;
                }
                DataEntry<K, Object> dataEntry = optionalDataEntry.get();
                UpdateStatus updateStatus = entry.getValue();
                if (updateStatus instanceof UpdateStatus.Skip) {
                    UpdateStatus.Skip skipStatus = (UpdateStatus.Skip)updateStatus;
                    if (skipStatus.skip()) {
                        entry.setValue(skipStatus.decrement());
                        continue;
                    }
                    entry.setValue(UpdateStatus.DEFAULT);
                    continue;
                }
                if (updateStatus == UpdateStatus.RESET) {
                    dataEntry.setValue((Object)null);
                    entry.setValue(new UpdateStatus.Skip(this.maxSkips));
                    continue;
                }
                if (!(updateStatus instanceof UpdateStatus.Set)) continue;
                UpdateStatus.Set setStatus = (UpdateStatus.Set)updateStatus;
                Object value = setStatus.getValue();
                dataEntry.setValue(value);
                entry.setValue(UpdateStatus.DEFAULT);
            }
        };
    }

    @Override
    public void onCreate(DataEntry<K, V> entry) {
        this.map.put(entry.getKey(), UpdateStatus.DEFAULT);
    }

    @Override
    public void onRemove(DataEntry<K, V> entry) {
        this.map.remove(entry.getKey());
    }

    public static enum FilterResult {
        SKIP,
        RESET,
        CONTINUE;

    }
}

