/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.query.simple;

import java.util.Optional;
import java.util.regex.Pattern;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.simple.SimpleQuery;
import org.jetbrains.annotations.NotNull;

public final class SimpleQueryContext
implements SimpleQuery.Context {
    @NotNull
    public final String name;
    @NotNull
    public final String args;
    @NotNull
    private final String actionName;

    public SimpleQueryContext(@NotNull String name, @NotNull String args, @NotNull String actionName) {
        this.name = name;
        this.args = args;
        this.actionName = actionName;
    }

    public static Optional<SimpleQueryContext> fromQuery(@NotNull String query, boolean singleName, @NotNull String separator) {
        String args;
        String actionName;
        String name;
        if (singleName) {
            String[] split = query.split(Pattern.quote(separator), 2);
            name = "";
            actionName = split[0];
            args = split.length > 1 ? split[1] : "";
        } else {
            String[] split = query.split(Pattern.quote(separator), 3);
            if (split.length < 2) {
                return Optional.empty();
            }
            name = split[0];
            actionName = split[1];
            args = split.length > 2 ? split[2] : "";
        }
        return Optional.of(new SimpleQueryContext(name, args, actionName));
    }

    public static Optional<SimpleQueryContext> fromQuery(@NotNull String query, boolean singleName) {
        return SimpleQueryContext.fromQuery(query, singleName, ";");
    }

    @Override
    @NotNull
    public String getActionName() {
        return this.actionName;
    }
}

