/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.core.AgentHolder;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.core.DataStorage;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.TopPlayerNumberTemplate;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.NumberTopHolder;

public class TopManager {
    private final Map<String, NumberTopHolder> holders = new HashMap<String, NumberTopHolder>();
    private final TopPlayerNumberTemplate template;
    private Function<String, DataStorage<UUID, Double>> storageSupplier;

    public TopManager(TopPlayerNumberTemplate template) {
        this.template = template;
    }

    public void enable() {
        this.storageSupplier = this.template.getStorageSupplier();
        this.template.getSettings().holders().forEach((key, value) -> {
            NumberTopHolder topHolder = new NumberTopHolder(this.template, (String)key, (NumberTopHolder.Settings)value);
            topHolder.register();
            this.holders.put((String)key, topHolder);
        });
    }

    public void disable() {
        this.holders.values().forEach(AgentHolder::unregister);
        this.holders.clear();
    }

    public Optional<NumberTopHolder> getHolder(String name) {
        return Optional.ofNullable(this.holders.get(name));
    }

    public List<String> getHolderNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.holders.keySet()));
    }

    public void create(UUID uuid) {
        this.holders.values().forEach(holder -> holder.getOrCreateEntry(uuid));
    }

    public DataStorage<UUID, Double> buildStorage(String name) {
        return this.storageSupplier.apply(name);
    }
}

