/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.value.timeformat;

import java.lang.reflect.Method;

public final class DurationTimeFormatters {
    private static final Method FORMAT_DURATION_METHOD;
    private static final Method FORMAT_DURATION_WORDS_METHOD;

    private DurationTimeFormatters() {
    }

    public static String formatDuration(long durationMillis, String format) {
        if (FORMAT_DURATION_METHOD != null) {
            try {
                return (String)FORMAT_DURATION_METHOD.invoke(null, durationMillis, format);
            }
            catch (Exception e) {
                return "INVALID FORMAT";
            }
        }
        return "NOT SUPPORTED";
    }

    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        if (FORMAT_DURATION_WORDS_METHOD != null) {
            try {
                return (String)FORMAT_DURATION_WORDS_METHOD.invoke(null, durationMillis, suppressLeadingZeroElements, suppressTrailingZeroElements);
            }
            catch (Exception e) {
                return "INVALID FORMAT";
            }
        }
        return "NOT SUPPORTED";
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.apache.commons.lang3.time.DurationFormatUtils");
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName("org.apache.commons.lang.time.DurationFormatUtils");
            }
            catch (ClassNotFoundException ex) {
                clazz = null;
            }
        }
        Method method = null;
        if (clazz != null) {
            try {
                method = clazz.getMethod("formatDuration", Long.TYPE, String.class);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        FORMAT_DURATION_METHOD = method;
        Method wordsMethod = null;
        if (clazz != null) {
            try {
                wordsMethod = clazz.getMethod("formatDurationWords", Long.TYPE, Boolean.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        FORMAT_DURATION_WORDS_METHOD = wordsMethod;
    }
}

