/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.hook.luckperms;

import java.util.Map;
import java.util.Optional;
import me.hsgamer.topper.spigot.plugin.TopperPlugin;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager.EntryConsumeManager;
import me.hsgamer.topper.spigot.plugin.template.SpigotTopTemplate;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TopContextCalculator
implements ContextCalculator<Player> {
    private final TopperPlugin plugin;

    public TopContextCalculator(TopperPlugin plugin) {
        this.plugin = plugin;
    }

    public void calculate(@NotNull Player player, @NotNull ContextConsumer contextConsumer) {
        EntryConsumeManager entryConsumeManager = this.plugin.get(SpigotTopTemplate.class).getEntryConsumeManager();
        for (Map.Entry<String, EntryConsumeManager.Provider> entry : entryConsumeManager.getProviderMap().entrySet()) {
            String group = entry.getKey();
            EntryConsumeManager.Provider provider = entry.getValue();
            for (String holder : provider.getHolders()) {
                Optional<Integer> snapshotIndex = provider.getSnapshotIndex(holder, player.getUniqueId()).filter(i -> i >= 0);
                snapshotIndex.ifPresent(index -> contextConsumer.accept(String.join((CharSequence)"_", group, "rank", holder), Integer.toString(index + 1)));
            }
        }
    }

    @NotNull
    public ContextSet estimatePotentialContexts() {
        ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
        EntryConsumeManager entryConsumeManager = this.plugin.get(SpigotTopTemplate.class).getEntryConsumeManager();
        for (Map.Entry<String, EntryConsumeManager.Provider> entry : entryConsumeManager.getProviderMap().entrySet()) {
            String group = entry.getKey();
            EntryConsumeManager.Provider provider = entry.getValue();
            for (String holder : provider.getHolders()) {
                for (int index = 0; index < 10; ++index) {
                    builder.add(String.join((CharSequence)"_", group, "rank", holder), Integer.toString(index + 1));
                }
            }
        }
        return builder.build();
    }
}

