/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.database.client.sql.java;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import me.hsgamer.topper.spigot.plugin.lib.core.database.Driver;
import me.hsgamer.topper.spigot.plugin.lib.core.database.Setting;
import me.hsgamer.topper.spigot.plugin.lib.core.database.client.sql.SqlClient;

public class JavaSqlClient
implements SqlClient<Properties> {
    private final Setting setting;
    private final Properties properties;
    private final String dbURL;
    private final java.sql.Driver sqlDriver;

    public JavaSqlClient(Setting setting) {
        this.setting = setting;
        Driver driver = setting.getDriver();
        this.properties = new Properties();
        try {
            this.sqlDriver = driver.getDriverClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load the driver", e);
        }
        this.properties.setProperty("user", setting.getUsername());
        this.properties.setProperty("password", setting.getPassword());
        setting.getClientProperties().forEach((k, v) -> this.properties.setProperty((String)k, String.valueOf(v)));
        this.dbURL = driver.convertURL(setting);
    }

    @Override
    public Setting getSetting() {
        return this.setting;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.sqlDriver.connect(this.dbURL, this.properties);
        }
        catch (IllegalArgumentException | SecurityException ex) {
            return DriverManager.getConnection(this.dbURL, this.properties);
        }
    }

    @Override
    public Properties getOriginal() {
        return this.properties;
    }
}

