/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.logger.provider;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.LogLevel;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.Logger;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.jul.JulLogger;

public class LoggerProvider {
    private static final Map<String, Logger> LOGGER_MAP = new ConcurrentHashMap<String, Logger>();
    private static Function<String, Logger> LOGGER_PROVIDER = JulLogger::new;

    private LoggerProvider() {
    }

    public static void setLoggerProvider(Function<String, Logger> loggerProvider) {
        LOGGER_PROVIDER = loggerProvider;
    }

    public static Logger getLogger(String name) {
        return LOGGER_MAP.computeIfAbsent(name, s -> new Logger((String)s){
            private Logger logger;
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
            }

            private Logger getLogger() {
                if (this.logger == null) {
                    this.logger = (Logger)LOGGER_PROVIDER.apply(this.val$s);
                }
                return this.logger;
            }

            @Override
            public void log(LogLevel level, String message) {
                this.getLogger().log(level, message);
            }

            @Override
            public void log(String message) {
                this.getLogger().log(message);
            }

            @Override
            public void log(LogLevel level, Throwable throwable) {
                this.getLogger().log(level, throwable);
            }

            @Override
            public void log(LogLevel level, String message, Throwable throwable) {
                this.getLogger().log(level, message, throwable);
            }
        });
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerProvider.getLogger(clazz.getSimpleName());
    }
}

