/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.command;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.BasePlugin;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.Loadable;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;

public class CommandComponent
implements Loadable {
    private static final Supplier<CommandMap> COMMAND_MAP_SUPPLIER;
    private static final Supplier<Map<?, ?>> KNOWN_COMMANDS_SUPPLIER;
    private static final Runnable SYNC_COMMANDS_RUNNABLE;
    private final BasePlugin plugin;
    private final List<Command> commands;
    private final Map<String, Command> registered = new HashMap<String, Command>();

    public CommandComponent(BasePlugin plugin, List<Command> commands) {
        this.plugin = plugin;
        this.commands = commands;
    }

    public CommandComponent(BasePlugin plugin, Command ... commands) {
        this(plugin, Arrays.asList(commands));
    }

    public CommandComponent(BasePlugin plugin, Supplier<List<Command>> commandSupplier) {
        this.plugin = plugin;
        this.commands = commandSupplier.get();
    }

    public static void syncCommand() {
        SYNC_COMMANDS_RUNNABLE.run();
    }

    public static void unregisterFromKnownCommands(Command command) {
        Map<?, ?> knownCommands = KNOWN_COMMANDS_SUPPLIER.get();
        knownCommands.values().removeIf(command::equals);
        command.unregister(COMMAND_MAP_SUPPLIER.get());
    }

    public static void registerCommandToCommandMap(String label, Command command) {
        COMMAND_MAP_SUPPLIER.get().register(label, command);
    }

    public void register(Command command) {
        String name = command.getLabel();
        if (this.registered.containsKey(name)) {
            this.plugin.getLogger().log(Level.WARNING, "Duplicated \"{0}\" command ! Ignored", name);
            return;
        }
        CommandComponent.registerCommandToCommandMap(this.plugin.getName(), command);
        this.registered.put(name, command);
    }

    public void unregister(Command command) {
        CommandComponent.unregisterFromKnownCommands(command);
        this.registered.remove(command.getLabel());
    }

    public void unregister(String command) {
        if (this.registered.containsKey(command)) {
            this.unregister(this.registered.remove(command));
        }
    }

    public void unregisterAll() {
        this.registered.values().forEach(CommandComponent::unregisterFromKnownCommands);
        this.registered.clear();
    }

    public Map<String, Command> getRegistered() {
        return Collections.unmodifiableMap(this.registered);
    }

    @Override
    public void enable() {
        this.commands.forEach(this::register);
        CommandComponent.syncCommand();
    }

    @Override
    public void disable() {
        this.unregisterAll();
    }

    static {
        Runnable syncCommandsRunnable;
        Supplier<Map> knownCommandsSupplier;
        Method commandMapMethod;
        try {
            commandMapMethod = Bukkit.getServer().getClass().getMethod("getCommandMap", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        COMMAND_MAP_SUPPLIER = () -> {
            try {
                return (CommandMap)commandMapMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        };
        try {
            Method knownCommandsMethod = SimpleCommandMap.class.getDeclaredMethod("getKnownCommands", new Class[0]);
            knownCommandsSupplier = () -> {
                try {
                    return (Map)knownCommandsMethod.invoke((Object)COMMAND_MAP_SUPPLIER.get(), new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new ExceptionInInitializerError(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            try {
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                knownCommandsSupplier = () -> {
                    try {
                        return (Map)knownCommandsField.get(COMMAND_MAP_SUPPLIER.get());
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new ExceptionInInitializerError(ex);
                    }
                };
            }
            catch (ReflectiveOperationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        KNOWN_COMMANDS_SUPPLIER = knownCommandsSupplier;
        try {
            Class<?> craftServer = Bukkit.getServer().getClass();
            Method syncCommandsMethod = craftServer.getDeclaredMethod("syncCommands", new Class[0]);
            syncCommandsMethod.setAccessible(true);
            syncCommandsRunnable = () -> {
                try {
                    syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    Bukkit.getLogger().log(Level.WARNING, "Error when syncing commands", e);
                }
            };
        }
        catch (Exception e) {
            syncCommandsRunnable = () -> {};
        }
        SYNC_COMMANDS_RUNNABLE = syncCommandsRunnable;
    }
}

