/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.permission;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.BasePlugin;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.Loadable;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;

public class PermissionComponent
implements Loadable {
    private final List<Permission> permissions = new ArrayList<Permission>();
    private boolean enabled = false;

    public PermissionComponent(List<Permission> permissions) {
        this.permissions.addAll(permissions);
    }

    public PermissionComponent(BasePlugin plugin) {
        Class[] classes;
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Class clazz : classes = new Class[]{this.getClass(), plugin.getClass()}) {
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!field.getType().equals(Permission.class) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                try {
                    Permission permission = (Permission)field.get(null);
                    permissions.add(permission);
                }
                catch (IllegalAccessException e) {
                    plugin.getLogger().warning("Failed to access permission field: " + field.getName());
                }
            }
        }
        this.permissions.addAll(permissions);
    }

    public void addPermission(Permission permission) {
        if (this.permissions.contains(permission)) {
            return;
        }
        this.permissions.add(permission);
        if (this.enabled) {
            Bukkit.getPluginManager().addPermission(permission);
        }
    }

    public void removePermission(Permission permission) {
        if (this.permissions.remove(permission) && this.enabled) {
            Bukkit.getPluginManager().removePermission(permission);
        }
    }

    @Override
    public void enable() {
        for (Permission permission : this.permissions) {
            Bukkit.getPluginManager().addPermission(permission);
        }
        this.enabled = true;
    }

    @Override
    public void disable() {
        for (Permission permission : this.permissions) {
            Bukkit.getPluginManager().removePermission(permission);
        }
        this.enabled = false;
    }
}

