/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.query.display.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.simple.SimpleQueryDisplay;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.timeformat.DateTimeFormatters;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.timeformat.DurationTimeFormatters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NumberDisplay<K, V extends Number>
implements SimpleQueryDisplay<K, V> {
    private static final Pattern VALUE_PLACEHOLDER_PATTERN = Pattern.compile("\\{value(?:_(.*))?}");
    private static final String FORMAT_QUERY_DECIMAL = "decimal";
    private static final String FORMAT_QUERY_TIME = "time";
    private static final String FORMAT_QUERY_SHORTEN = "shorten";
    private static final Map<String, Function<Number, String>> displayByQueryCache = new ConcurrentHashMap<String, Function<Number, String>>();
    private final String line;
    private final String displayNullValue;

    protected NumberDisplay(String line, String displayNullValue) {
        this.line = line;
        this.displayNullValue = displayNullValue;
    }

    private static Map<String, String> getSettings(String query) {
        if (query.isEmpty()) {
            return Collections.emptyMap();
        }
        if (query.startsWith(":")) {
            query = query.substring(1);
        }
        String separator = "&";
        String keyValueSeparator = "=";
        return Arrays.stream(query.split(Pattern.quote("&"))).map(s -> s.split(Pattern.quote("="), 2)).filter(a -> ((String[])a).length == 2).collect(Collectors.toMap(a -> a[0], a -> a[1], (a, b) -> a));
    }

    private static Function<Number, String> createDisplayFunction(String formatQuery) {
        Map<String, String> settings;
        if (formatQuery.startsWith(FORMAT_QUERY_SHORTEN)) {
            String config = formatQuery.substring(FORMAT_QUERY_SHORTEN.length());
            TreeMap<Double, String> suffixMap = new TreeMap<Double, String>();
            if (config.isEmpty()) {
                suffixMap.put(1000.0, "k");
                suffixMap.put(1000000.0, "M");
                suffixMap.put(1.0E9, "B");
                suffixMap.put(1.0E12, "T");
            } else {
                Map<String, String> settings2 = NumberDisplay.getSettings(config);
                for (Map.Entry<String, String> entry : settings2.entrySet()) {
                    try {
                        double threshold = Double.parseDouble(entry.getKey());
                        String suffix = entry.getValue();
                        suffixMap.put(threshold, suffix);
                    }
                    catch (NumberFormatException ignored) {
                        return n -> "INVALID_NUMBER_FOR_SHORTEN_SUFFIX";
                    }
                }
            }
            return n -> {
                double value = n.doubleValue();
                if (suffixMap.isEmpty()) {
                    if (value == (double)((long)value)) {
                        return String.format(Locale.ENGLISH, "%,d", (long)value);
                    }
                    BigDecimal bd = BigDecimal.valueOf(value);
                    bd = bd.setScale(2, RoundingMode.DOWN);
                    return bd.stripTrailingZeros().toPlainString();
                }
                boolean isNegative = value < 0.0;
                double absValue = Math.abs(value);
                Map.Entry entry = suffixMap.floorEntry(absValue);
                if (entry == null || entry.getKey() == 0.0 || absValue < 1000.0) {
                    if (absValue == (double)((long)absValue)) {
                        return (isNegative ? "-" : "") + String.format(Locale.ENGLISH, "%,d", (long)absValue);
                    }
                    BigDecimal bd = BigDecimal.valueOf(absValue);
                    bd = bd.setScale(2, RoundingMode.DOWN);
                    String formatted = bd.stripTrailingZeros().toPlainString();
                    return (isNegative ? "-" : "") + formatted;
                }
                double threshold = entry.getKey();
                String suffix = (String)entry.getValue();
                BigDecimal divided = BigDecimal.valueOf(absValue).divide(BigDecimal.valueOf(threshold), 10, RoundingMode.DOWN);
                divided = divided.setScale(2, RoundingMode.DOWN);
                String formatted = divided.stripTrailingZeros().toPlainString();
                return (isNegative ? "-" : "") + formatted + suffix;
            };
        }
        if (formatQuery.startsWith(FORMAT_QUERY_TIME)) {
            Function<Number, Long> toMillis;
            settings = NumberDisplay.getSettings(formatQuery.substring(FORMAT_QUERY_TIME.length()));
            String unitString = Optional.ofNullable(settings.get("unit")).orElse("ticks");
            if (unitString.equalsIgnoreCase("ticks")) {
                toMillis = n -> n.longValue() * 50L;
            } else {
                try {
                    TimeUnit unit = TimeUnit.valueOf(unitString.toUpperCase());
                    toMillis = n -> unit.toMillis(n.longValue());
                }
                catch (IllegalArgumentException e) {
                    return n -> "INVALID_UNIT";
                }
            }
            String type = Optional.ofNullable(settings.get("type")).orElse("duration");
            Optional<String> patternOptional = Optional.ofNullable(settings.get("pattern"));
            if (type.equalsIgnoreCase(FORMAT_QUERY_TIME)) {
                String pattern = patternOptional.orElse("RFC_1123_DATE_TIME");
                Optional<DateTimeFormatter> formatterOptional = DateTimeFormatters.getFormatter(pattern);
                if (!formatterOptional.isPresent()) {
                    return n -> "INVALID_FORMAT";
                }
                DateTimeFormatter formatter = formatterOptional.get();
                try {
                    return n -> {
                        long millis = (Long)toMillis.apply(n.longValue());
                        Instant date = Instant.ofEpochMilli(millis);
                        return formatter.format(date);
                    };
                }
                catch (IllegalArgumentException e) {
                    return n -> "CANNOT_FORMAT";
                }
            }
            if (type.equalsIgnoreCase("duration")) {
                String pattern = patternOptional.orElse("default");
                if (pattern.equalsIgnoreCase("default")) {
                    return toMillis.andThen(millis -> DurationTimeFormatters.formatDuration(millis, "HH:mm:ss"));
                }
                if (pattern.equalsIgnoreCase("word")) {
                    return toMillis.andThen(millis -> DurationTimeFormatters.formatDurationWords(millis, true, true));
                }
                if (pattern.equalsIgnoreCase("short")) {
                    return toMillis.andThen(millis -> DurationTimeFormatters.formatDuration(millis, "[H:]m:ss"));
                }
                if (pattern.equalsIgnoreCase("short-word")) {
                    return toMillis.andThen(millis -> DurationTimeFormatters.formatDuration(millis, "[d'd 'H'h 'm'm 's's']"));
                }
                return toMillis.andThen(millis -> DurationTimeFormatters.formatDuration(millis, pattern));
            }
        }
        if (formatQuery.startsWith(FORMAT_QUERY_DECIMAL)) {
            settings = NumberDisplay.getSettings(formatQuery.substring(FORMAT_QUERY_DECIMAL.length()));
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
            Optional.ofNullable(settings.get("decimalSeparator")).map(s -> Character.valueOf(s.charAt(0))).ifPresent(symbols::setDecimalSeparator);
            Optional.ofNullable(settings.get("groupingSeparator")).map(s -> Character.valueOf(s.charAt(0))).ifPresent(c -> {
                symbols.setGroupingSeparator(c.charValue());
                decimalFormat.setGroupingUsed(true);
            });
            Optional.ofNullable(settings.get("groupingSize")).flatMap(s -> {
                try {
                    return Optional.of(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return Optional.empty();
                }
            }).map(Number::intValue).ifPresent(decimalFormat::setGroupingSize);
            Optional.ofNullable(settings.get("maximumFractionDigits")).flatMap(s -> {
                try {
                    return Optional.of(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return Optional.empty();
                }
            }).map(Number::intValue).ifPresent(decimalFormat::setMaximumFractionDigits);
            decimalFormat.setDecimalFormatSymbols(symbols);
            return n -> ((DecimalFormat)decimalFormat.clone()).format(n);
        }
        try {
            DecimalFormat decimalFormat = new DecimalFormat(formatQuery);
            return n -> ((DecimalFormat)decimalFormat.clone()).format(n);
        }
        catch (IllegalArgumentException e) {
            return n -> "INVALID_FORMAT";
        }
    }

    @Override
    @NotNull
    public String getDisplayValue(@Nullable V value, @Nullable String formatQuery) {
        if (value == null) {
            return this.displayNullValue;
        }
        if (formatQuery == null) {
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            return decimalFormat.format(value);
        }
        if (formatQuery.equals("raw")) {
            return String.valueOf(value);
        }
        return (String)displayByQueryCache.computeIfAbsent(formatQuery, NumberDisplay::createDisplayFunction).apply(value);
    }

    public String getDisplayLine(int index, @Nullable Map.Entry<K, V> entry) {
        String line = this.line.replace("{index}", String.valueOf(index)).replace("{uuid}", this.getDisplayKey(entry == null ? null : (Object)entry.getKey())).replace("{name}", this.getDisplayName(entry == null ? null : (Object)entry.getKey()));
        Number value = entry == null ? (Number)null : (Number)((Number)entry.getValue());
        Matcher matcher = VALUE_PLACEHOLDER_PATTERN.matcher(line);
        while (matcher.find()) {
            String formatType = matcher.group(1);
            line = line.replace(matcher.group(), this.getDisplayValue((V)value, formatType));
        }
        return line;
    }
}

