/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.hsgamer.topper.spigot.plugin.lib.core.database.Driver;
import me.hsgamer.topper.spigot.plugin.lib.core.database.Setting;
import me.hsgamer.topper.spigot.plugin.lib.core.database.client.sql.BatchBuilder;
import me.hsgamer.topper.spigot.plugin.lib.core.database.client.sql.SqlClient;
import me.hsgamer.topper.spigot.plugin.lib.core.database.client.sql.StatementBuilder;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.LogLevel;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.Logger;
import me.hsgamer.topper.spigot.plugin.lib.core.logger.provider.LoggerProvider;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.core.DataStorage;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.core.SqlDatabaseSetting;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.core.SqlValueConverter;

public abstract class SqlDataStorageSupplier {
    protected final Logger logger = LoggerProvider.getLogger(this.getClass());
    private final SqlClient<?> client;
    private final Lock lock = new ReentrantLock();

    protected SqlDataStorageSupplier(Driver driver, SqlDatabaseSetting databaseSetting, Function<Setting, SqlClient<?>> clientFunction) {
        if (clientFunction == null) {
            throw new IllegalArgumentException("clientFunction is null");
        }
        this.client = clientFunction.apply(SqlDataStorageSupplier.applyDatabaseSetting(databaseSetting, Setting.create(driver)));
    }

    protected static Setting applyDatabaseSetting(SqlDatabaseSetting databaseSetting, Setting setting) {
        setting.setHost(databaseSetting.getHost());
        setting.setPort(databaseSetting.getPort());
        setting.setDatabaseName(databaseSetting.getDatabase());
        setting.setUsername(databaseSetting.getUsername());
        setting.setPassword(databaseSetting.getPassword());
        if (databaseSetting.isUseSSL()) {
            setting.setDriverProperty("useSSL", "true");
        }
        setting.setDriverProperties(databaseSetting.getDriverProperties());
        setting.setClientProperties(databaseSetting.getClientProperties());
        return setting;
    }

    public static StorageOptions options() {
        return new StorageOptions();
    }

    protected boolean isSingleThread() {
        return false;
    }

    protected abstract String getIncrementalKeyDefinition();

    protected abstract List<String> toSaveStatement(String var1, String[] var2, String[] var3);

    protected abstract List<Object[]> toSaveValues(Object[] var1, Object[] var2);

    private void lock() {
        if (this.isSingleThread()) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.isSingleThread()) {
            this.lock.unlock();
        }
    }

    public <K, V> DataStorage<K, V> getStorage(final String name, final SqlValueConverter<K> keyConverter, final SqlValueConverter<V> valueConverter, final StorageOptions options) {
        return new DataStorage<K, V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<K, V> load() {
                SqlDataStorageSupplier.this.lock();
                try {
                    Map<Object, Object> map;
                    block11: {
                        Connection connection = SqlDataStorageSupplier.this.client.getConnection();
                        try {
                            map = StatementBuilder.create(connection).setStatement("SELECT * FROM `" + name + "`;").queryList(resultSet -> new AbstractMap.SimpleEntry(keyConverter.fromSqlResultSet(resultSet), valueConverter.fromSqlResultSet(resultSet))).stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                            if (connection == null) break block11;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException e) {
                                SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load holder", e);
                                Map map2 = Collections.emptyMap();
                                return map2;
                            }
                        }
                        connection.close();
                    }
                    return map;
                }
                finally {
                    SqlDataStorageSupplier.this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Optional<V> load(K key) {
                SqlDataStorageSupplier.this.lock();
                try {
                    Optional optional;
                    block12: {
                        Connection connection = SqlDataStorageSupplier.this.client.getConnection();
                        try {
                            String[] keyColumns = keyConverter.getSqlColumns();
                            Object[] keyValues = keyConverter.toSqlValues(key);
                            StringBuilder statement = new StringBuilder("SELECT * FROM `").append(name).append("` WHERE ");
                            for (int i = 0; i < keyColumns.length; ++i) {
                                statement.append("`").append(keyColumns[i]).append("` = ?");
                                if (i == keyColumns.length - 1) continue;
                                statement.append(" AND ");
                            }
                            optional = StatementBuilder.create(connection).setStatement(statement.toString()).addValues(keyValues).query(resultSet -> resultSet.next() ? Optional.ofNullable(valueConverter.fromSqlResultSet(resultSet)) : Optional.empty());
                            if (connection == null) break block12;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException e) {
                                SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load holder", e);
                                Optional optional2 = Optional.empty();
                                return optional2;
                            }
                        }
                        connection.close();
                    }
                    return optional;
                }
                finally {
                    SqlDataStorageSupplier.this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<K> keys() {
                SqlDataStorageSupplier.this.lock();
                try {
                    List<Object> list;
                    block11: {
                        Connection connection = SqlDataStorageSupplier.this.client.getConnection();
                        try {
                            String columnQuery = Arrays.stream(keyConverter.getSqlColumns()).map(s -> "`" + s + "`").collect(Collectors.joining(", "));
                            list = StatementBuilder.create(connection).setStatement("SELECT " + columnQuery + " FROM `" + name + "`;").queryList(keyConverter::fromSqlResultSet);
                            if (connection == null) break block11;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException e) {
                                SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load holder", e);
                                List list2 = Collections.emptyList();
                                return list2;
                            }
                        }
                        connection.close();
                    }
                    return list;
                }
                finally {
                    SqlDataStorageSupplier.this.unlock();
                }
            }

            @Override
            public Optional<DataStorage.Modifier<K, V>> modify() {
                SqlDataStorageSupplier.this.lock();
                try {
                    final Connection connection = SqlDataStorageSupplier.this.client.getConnection();
                    connection.setAutoCommit(false);
                    DataStorage.Modifier modifier = new DataStorage.Modifier<K, V>(){

                        @Override
                        public void save(Map<K, V> map) throws SQLException {
                            String[] keyColumns = keyConverter.getSqlColumns();
                            String[] valueColumns = valueConverter.getSqlColumns();
                            List<String> statement = SqlDataStorageSupplier.this.toSaveStatement(name, keyColumns, valueColumns);
                            ArrayList values = new ArrayList();
                            map.forEach((key, value) -> {
                                Object[] keyValues = keyConverter.toSqlValues(key);
                                Object[] valueValues = valueConverter.toSqlValues(value);
                                values.add(SqlDataStorageSupplier.this.toSaveValues(keyValues, valueValues));
                            });
                            for (int i = 0; i < statement.size(); ++i) {
                                BatchBuilder batchBuilder = BatchBuilder.create(connection, statement.get(i));
                                for (List value2 : values) {
                                    batchBuilder.addValues((Object[])value2.get(i));
                                }
                                batchBuilder.execute();
                            }
                        }

                        @Override
                        public void remove(Collection<K> keys) throws SQLException {
                            String[] keyColumns = keyConverter.getSqlColumns();
                            StringBuilder statement = new StringBuilder("DELETE FROM `").append(name).append("` WHERE ");
                            for (int i = 0; i < keyColumns.length; ++i) {
                                statement.append("`").append(keyColumns[i]).append("` = ?");
                                if (i == keyColumns.length - 1) continue;
                                statement.append(" AND ");
                            }
                            BatchBuilder batchBuilder = BatchBuilder.create(connection, statement.toString());
                            keys.forEach(key -> {
                                Object[] keyValues = keyConverter.toSqlValues(key);
                                batchBuilder.addValues(keyValues);
                            });
                            batchBuilder.execute();
                        }

                        private void close() {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to close connection", e);
                            }
                        }

                        @Override
                        public void commit() {
                            try {
                                connection.commit();
                            }
                            catch (SQLException e) {
                                SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to commit", e);
                            }
                            finally {
                                this.close();
                                SqlDataStorageSupplier.this.unlock();
                            }
                        }

                        @Override
                        public void rollback() {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException e) {
                                SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to rollback", e);
                            }
                            finally {
                                this.close();
                                SqlDataStorageSupplier.this.unlock();
                            }
                        }
                    };
                    return Optional.of(modifier);
                }
                catch (SQLException e) {
                    SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to get connection", e);
                    SqlDataStorageSupplier.this.unlock();
                    return Optional.empty();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegister() {
                SqlDataStorageSupplier.this.lock();
                try (Connection connection = SqlDataStorageSupplier.this.client.getConnection();){
                    int i;
                    String incrementalKey = options.incrementalKey;
                    String[] keyColumns = keyConverter.getSqlColumns();
                    String[] keyColumnDefinitions = keyConverter.getSqlColumnDefinitions();
                    String[] valueColumns = valueConverter.getSqlColumns();
                    String[] valueColumnDefinitions = valueConverter.getSqlColumnDefinitions();
                    StringBuilder statement = new StringBuilder("CREATE TABLE IF NOT EXISTS `").append(name).append("` (");
                    if (incrementalKey != null) {
                        String incrementalKeyDefinition = SqlDataStorageSupplier.this.getIncrementalKeyDefinition();
                        statement.append("`").append(incrementalKey).append("` ").append(incrementalKeyDefinition).append(", ");
                    }
                    for (i = 0; i < keyColumns.length + valueColumns.length; ++i) {
                        boolean isKey = i < keyColumns.length;
                        int index = isKey ? i : i - keyColumns.length;
                        statement.append("`").append(isKey ? keyColumns[index] : valueColumns[index]).append("` ").append(isKey ? keyColumnDefinitions[index] : valueColumnDefinitions[index]);
                        if (i == keyColumns.length + valueColumns.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(", ");
                    statement.append(incrementalKey != null ? "UNIQUE (" : "PRIMARY KEY (");
                    for (i = 0; i < keyColumns.length; ++i) {
                        statement.append("`").append(keyColumns[i]).append("`");
                        if (i == keyColumns.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(")");
                    statement.append(");");
                    StatementBuilder.create(connection).setStatement(statement.toString()).update();
                }
                catch (SQLException e) {
                    SqlDataStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to create table", e);
                }
                finally {
                    SqlDataStorageSupplier.this.unlock();
                }
            }
        };
    }

    public <K, V> DataStorage<K, V> getStorage(String name, SqlValueConverter<K> keyConverter, SqlValueConverter<V> valueConverter) {
        return this.getStorage(name, keyConverter, valueConverter, StorageOptions.DEFAULT);
    }

    public static class StorageOptions {
        public static final StorageOptions DEFAULT = new StorageOptions();
        private String incrementalKey = null;

        private StorageOptions() {
        }

        public StorageOptions setIncrementalKey(String incrementalKey) {
            this.incrementalKey = incrementalKey;
            return this;
        }

        public StorageOptions useIncrementalKey() {
            return this.setIncrementalKey("id");
        }
    }
}

