/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.hsgamer.topper.spigot.plugin.lib.topper.data.core.DataEntry;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.TopPlayerNumberTemplate;
import me.hsgamer.topper.spigot.plugin.lib.topper.template.topplayernumber.holder.NumberTopHolder;
import org.jetbrains.annotations.Nullable;

public class EntryConsumeManager {
    private final TopPlayerNumberTemplate template;
    private final List<Consumer<Context>> consumerList = new ArrayList<Consumer<Context>>();
    private final Map<String, Provider> providerMap = new HashMap<String, Provider>();

    public EntryConsumeManager(TopPlayerNumberTemplate template) {
        this.template = template;
    }

    public Runnable addConsumer(Consumer<Context> consumer) {
        this.consumerList.add(consumer);
        return () -> this.consumerList.remove(consumer);
    }

    public Runnable addConsumer(String group, String holder, BiConsumer<UUID, Double> consumer) {
        return this.addConsumer(context -> {
            if (Objects.equals(context.group, group) && Objects.equals(context.holder, holder)) {
                consumer.accept(context.uuid, context.value);
            }
        });
    }

    public Runnable addProvider(String group, Provider provider) {
        this.providerMap.put(group, provider);
        return () -> this.providerMap.remove(group);
    }

    public Provider getProvider(String group) {
        return this.providerMap.getOrDefault(group, Provider.DEFAULT);
    }

    public Map<String, Provider> getProviderMap() {
        return Collections.unmodifiableMap(this.providerMap);
    }

    public void consume(Context context) {
        this.consumerList.forEach(consumer -> consumer.accept(context));
    }

    public void enable() {
        this.addProvider("topper", new Provider(){

            @Override
            public Collection<String> getHolders() {
                return EntryConsumeManager.this.template.getTopManager().getHolderNames();
            }

            @Override
            public Optional<Double> getValue(String holder, UUID uuid) {
                return EntryConsumeManager.this.template.getTopManager().getHolder(holder).flatMap(h -> h.getEntry(uuid)).map(DataEntry::getValue);
            }

            @Override
            public Optional<String> getName(String holder, UUID uuid) {
                return Optional.ofNullable(EntryConsumeManager.this.template.getName(uuid));
            }

            @Override
            public Optional<Integer> getSnapshotIndex(String holder, UUID uuid) {
                return EntryConsumeManager.this.template.getTopManager().getHolder(holder).map(NumberTopHolder::getSnapshotAgent).map(agent -> agent.getSnapshotIndex(uuid));
            }
        });
    }

    public void disable() {
        this.consumerList.clear();
        this.providerMap.clear();
    }

    public static interface Provider {
        public static final Provider DEFAULT = new Provider(){};

        default public Collection<String> getHolders() {
            return Collections.emptyList();
        }

        default public Optional<Double> getValue(String holder, UUID uuid) {
            return Optional.empty();
        }

        default public Optional<String> getName(String holder, UUID uuid) {
            return Optional.empty();
        }

        default public Optional<Integer> getSnapshotIndex(String holder, UUID uuid) {
            return Optional.empty();
        }
    }

    public static class Context {
        public final String group;
        public final String holder;
        public final UUID uuid;
        @Nullable
        public final Double oldValue;
        @Nullable
        public final Double value;

        public Context(String group, String holder, UUID uuid, @Nullable Double oldValue, @Nullable Double value) {
            this.group = group;
            this.holder = holder;
            this.uuid = uuid;
            this.oldValue = oldValue;
            this.value = value;
        }
    }
}

