/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.hook;

import java.util.ArrayList;
import java.util.List;
import me.hsgamer.topper.spigot.plugin.TopperPlugin;
import me.hsgamer.topper.spigot.plugin.hook.miniplaceholders.MiniPlaceholdersHook;
import me.hsgamer.topper.spigot.plugin.hook.placeholderapi.PlaceholderAPIHook;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.Loadable;

public class HookSystem
implements Loadable {
    private final TopperPlugin instance;
    private final List<Loadable> hooks = new ArrayList<Loadable>();

    public HookSystem(TopperPlugin instance) {
        this.instance = instance;
    }

    private boolean isPluginLoaded(String pluginName) {
        return this.instance.getServer().getPluginManager().getPlugin(pluginName) != null;
    }

    private void registerHooks() {
        if (this.isPluginLoaded("PlaceholderAPI")) {
            this.hooks.add(new PlaceholderAPIHook(this.instance));
        }
        if (this.isPluginLoaded("MiniPlaceholders")) {
            this.hooks.add(new MiniPlaceholdersHook(this.instance));
        }
    }

    @Override
    public void load() {
        this.registerHooks();
        this.hooks.forEach(Loadable::load);
    }

    @Override
    public void enable() {
        this.hooks.forEach(Loadable::enable);
    }

    @Override
    public void disable() {
        this.hooks.forEach(Loadable::disable);
    }
}

