/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.hook.miniplaceholders;

import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import me.hsgamer.topper.spigot.plugin.TopperPlugin;
import me.hsgamer.topper.spigot.plugin.lib.minelib.plugin.base.Loadable;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.core.QueryResult;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.forward.QueryForwardContext;
import me.hsgamer.topper.spigot.plugin.lib.topper.spigot.query.forward.miniplaceholders.MiniPlaceholdersQueryForwarder;
import me.hsgamer.topper.spigot.plugin.lib.topper.spigot.value.miniplaceholders.MiniPlaceholderValueProvider;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.string.StringDeformatters;
import me.hsgamer.topper.spigot.plugin.manager.ValueProviderManager;
import me.hsgamer.topper.spigot.plugin.template.SpigotTopTemplate;
import me.hsgamer.topper.spigot.plugin.util.ParseUtil;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniPlaceholdersHook
implements Loadable {
    private final TopperPlugin plugin;
    private final MiniPlaceholdersQueryForwarder<QueryForwardContext<UUID>> queryForwarder = new MiniPlaceholdersQueryForwarder();

    public MiniPlaceholdersHook(TopperPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.plugin.get(ValueProviderManager.class).register(map -> {
            String placeholder = Optional.ofNullable(map.get("placeholder")).map(Object::toString).orElse("");
            return new MiniPlaceholderValueProvider(placeholder).thenApply(StringDeformatters.deformatterOrIdentity(map)).thenApply(ParseUtil::parsePlaceholderNumber).beforeApply(Bukkit::getPlayer);
        }, "miniplaceholders", "miniplaceholder", "mini-placeholders", "mini-placeholder");
        this.plugin.get(SpigotTopTemplate.class).getQueryForwardManager().addForwarder(context -> this.queryForwarder.accept(new QueryForwardContext<UUID>(){

            @Override
            public String getName() {
                return context.getName();
            }

            @Override
            public BiFunction<@Nullable UUID, @NotNull String, @NotNull QueryResult> getQuery() {
                return context.getQuery();
            }
        }));
    }

    @Override
    public void disable() {
        this.queryForwarder.unregister();
    }
}

