/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.bukkit.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class ItemUtils {
    private ItemUtils() {
    }

    public static void giveItem(Player player, ItemStack ... itemStack) {
        player.getInventory().addItem(itemStack).values().forEach(remainingItemStack -> player.getWorld().dropItem(player.getLocation(), remainingItemStack));
    }

    public static List<ItemStack> getMatchedItemsInInventory(Inventory inventory, Predicate<ItemStack> predicate, int maxAmount) {
        return ItemUtils.createItemCheckSession((Inventory)inventory, predicate, (int)maxAmount).matchedItems;
    }

    public static void removeItemInInventory(Inventory inventory, Collection<ItemStack> items) {
        for (ItemStack item : items) {
            inventory.removeItem(new ItemStack[]{item});
        }
    }

    public static void removeItemInInventory(Inventory inventory, Predicate<ItemStack> predicate, int amount) {
        ItemUtils.createItemCheckSession((Inventory)inventory, predicate, (int)amount).takeRunnable.run();
    }

    public static Predicate<ItemStack> getItemPredicate(ItemStack itemStack) {
        return i -> i.isSimilar(itemStack);
    }

    public static boolean isItemFullOnInventory(Inventory inventory, Collection<ItemStack> items) {
        for (ItemStack item : items) {
            if (!ItemUtils.isItemFullOnInventory(inventory, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemFullOnInventory(Inventory inventory, ItemStack item) {
        boolean canAdd = false;
        for (ItemStack i : inventory.getContents()) {
            if (i == null || i.getType() == Material.AIR) {
                canAdd = true;
            } else if (i.isSimilar(item)) {
                boolean bl = canAdd = i.getAmount() + item.getAmount() <= i.getMaxStackSize();
            }
            if (canAdd) break;
        }
        return !canAdd;
    }

    public static ItemCheckSession createItemCheckSession(Inventory inventory, Predicate<ItemStack> predicate, int maxAmount) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ArrayList<Runnable> takeRunnable = new ArrayList<Runnable>();
        int amountToCheck = maxAmount;
        ItemStack[] contents = inventory.getContents();
        for (int slot = 0; slot < contents.length && amountToCheck > 0; ++slot) {
            ItemStack i = contents[slot];
            if (i == null || !predicate.test(i)) continue;
            if (i.getAmount() > amountToCheck) {
                int lastItemRemaining = i.getAmount() - amountToCheck;
                takeRunnable.add(() -> i.setAmount(lastItemRemaining));
                ItemStack item = i.clone();
                item.setAmount(amountToCheck);
                list.add(item);
            } else {
                int finalSlot = slot;
                takeRunnable.add(() -> inventory.setItem(finalSlot, null));
                list.add(i.clone());
            }
            amountToCheck -= Math.min(amountToCheck, i.getAmount());
        }
        return new ItemCheckSession(list, () -> {
            for (Runnable runnable : takeRunnable) {
                runnable.run();
            }
        }, amountToCheck <= 0);
    }

    public static class ItemCheckSession {
        public final List<ItemStack> matchedItems;
        public final Runnable takeRunnable;
        public final boolean isAllMatched;

        private ItemCheckSession(List<ItemStack> matchedItems, Runnable takeRunnable, boolean isAllMatched) {
            this.matchedItems = matchedItems;
            this.takeRunnable = takeRunnable;
            this.isAllMatched = isAllMatched;
        }
    }
}

