/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.core.logger.common;

import me.hsgamer.topper.spigot.plugin.lib.core.logger.common.LogLevel;

public interface Logger {
    public void log(LogLevel var1, String var2);

    default public void log(String message) {
        this.log(LogLevel.INFO, message);
    }

    default public void log(LogLevel level, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.log(level, throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement element : throwable.getStackTrace()) {
            this.log(level, "    " + element.toString());
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            this.log(level, "Caused by: " + cause.getMessage());
            this.log(level, cause);
        }
    }

    default public void log(LogLevel level, String message, Throwable throwable) {
        this.log(level, message);
        this.log(level, throwable);
    }
}

