/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.query.snapshot;

import java.util.Map;
import java.util.Optional;
import me.hsgamer.topper.spigot.plugin.lib.topper.agent.snapshot.SnapshotAgent;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.simple.SimpleQuery;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.simple.SimpleQueryContext;
import me.hsgamer.topper.spigot.plugin.lib.topper.query.simple.SimpleQueryDisplay;
import org.jetbrains.annotations.NotNull;

public abstract class SnapshotQuery<K, V, A>
extends SimpleQuery<A, Context<K, V>> {
    protected SnapshotQuery(String prefix) {
        this.registerAction(prefix + "_name", (actor, context) -> {
            int i = 1;
            try {
                i = Integer.parseInt(context.parent.args);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Object key = context.agent.getSnapshotByIndex(i - 1).map(Map.Entry::getKey).orElse(null);
            return context.display.getDisplayName(key);
        });
        this.registerAction(prefix + "_key", (actor, context) -> {
            int i = 1;
            try {
                i = Integer.parseInt(context.parent.args);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Object key = context.agent.getSnapshotByIndex(i - 1).map(Map.Entry::getKey).orElse(null);
            return context.display.getDisplayKey(key);
        });
        this.registerAction(prefix + "_value", (actor, context) -> {
            String[] split = context.parent.args.split(";", 2);
            int i = 1;
            try {
                i = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String valueArgs = split.length > 1 ? split[1] : "";
            Object value = context.agent.getSnapshotByIndex(i - 1).map(Map.Entry::getValue).orElse(null);
            return context.display.getDisplayValue(value, valueArgs);
        });
        this.registerAction(prefix + "_value_raw", (actor, context) -> {
            int i = 1;
            try {
                i = Integer.parseInt(context.parent.args);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Object value = context.agent.getSnapshotByIndex(i - 1).map(Map.Entry::getValue).orElse(null);
            return context.display.getDisplayValue(value, "raw");
        });
        this.registerActorAction(prefix + "_rank", (actor, context) -> this.getKey((A)actor, (Context<K, V>)context).map(context.agent::getSnapshotIndex).map(index -> index + 1).map(rank -> this.getDisplayRank((int)rank, (Context<K, V>)context)).orElse("0"));
        this.registerAction(prefix + "_size", (actor, context) -> Integer.toString(context.agent.getSnapshot().size()));
    }

    protected SnapshotQuery() {
        this("top");
    }

    protected abstract Optional<SnapshotAgent<K, V>> getAgent(@NotNull String var1);

    protected abstract Optional<SimpleQueryDisplay<K, V>> getDisplay(@NotNull String var1);

    protected boolean isSingleAgent() {
        return false;
    }

    protected abstract Optional<K> getKey(@NotNull A var1, @NotNull Context<K, V> var2);

    @NotNull
    protected String getDisplayRank(int rank, @NotNull Context<K, V> context) {
        return Integer.toString(rank);
    }

    @Override
    protected Optional<Context<K, V>> getContext(@NotNull String query) {
        return SimpleQueryContext.fromQuery(query, this.isSingleAgent()).map(context -> {
            Optional<SnapshotAgent<K, V>> agent = this.getAgent(context.name);
            Optional<SimpleQueryDisplay<K, V>> display = this.getDisplay(context.name);
            if (!agent.isPresent() || !display.isPresent()) {
                return null;
            }
            return new Context<K, V>(agent.get(), display.get(), (SimpleQueryContext)context);
        });
    }

    public static final class Context<K, V>
    implements SimpleQuery.Context {
        @NotNull
        public final SnapshotAgent<K, V> agent;
        @NotNull
        public final SimpleQueryDisplay<K, V> display;
        @NotNull
        public final SimpleQueryContext parent;

        Context(@NotNull SnapshotAgent<K, V> agent, @NotNull SimpleQueryDisplay<K, V> display, @NotNull SimpleQueryContext parent) {
            this.agent = agent;
            this.display = display;
            this.parent = parent;
        }

        @Override
        @NotNull
        public String getActionName() {
            return this.parent.getActionName();
        }
    }
}

