/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.spigot.value.miniplaceholders;

import io.github.miniplaceholders.api.MiniPlaceholders;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueProvider;
import me.hsgamer.topper.spigot.plugin.lib.topper.value.core.ValueWrapper;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MiniPlaceholderValueProvider
implements ValueProvider<Player, String> {
    private final String placeholder;

    public MiniPlaceholderValueProvider(String placeholder) {
        this.placeholder = MiniPlaceholderValueProvider.normalizePlaceholder(placeholder);
    }

    private static String normalizePlaceholder(String placeholder) {
        return placeholder.isEmpty() || placeholder.startsWith("<") || placeholder.endsWith(">") ? placeholder : "<" + placeholder + ">";
    }

    @Override
    @NotNull
    public ValueWrapper<String> apply(@NotNull Player key) {
        String parsed;
        try {
            TagResolver tagResolver = MiniPlaceholders.audienceGlobalPlaceholders();
            Component component = MiniMessage.miniMessage().deserialize(this.placeholder, (Pointered)key, tagResolver);
            parsed = PlainTextComponentSerializer.plainText().serialize(component).trim();
        }
        catch (Exception e) {
            return ValueWrapper.error("Error while parsing the placeholder: " + this.placeholder, e);
        }
        if (this.placeholder.equals(parsed)) {
            return ValueWrapper.notHandled();
        }
        return ValueWrapper.handled(parsed);
    }
}

