/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.converter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import me.hsgamer.topper.spigot.plugin.lib.topper.storage.sql.core.SqlValueConverter;
import org.jetbrains.annotations.NotNull;

public class NumberSqlValueConverter<T extends Number>
implements SqlValueConverter<T> {
    private final String valueName;
    private final boolean isDoubleValue;
    private final Function<@NotNull Number, @NotNull T> numberFunction;

    public NumberSqlValueConverter(String valueName, boolean isDoubleValue, Function<@NotNull Number, @NotNull T> numberFunction) {
        this.valueName = valueName;
        this.isDoubleValue = isDoubleValue;
        this.numberFunction = numberFunction;
    }

    @Override
    public String[] getSqlColumns() {
        return new String[]{this.valueName};
    }

    @Override
    public String[] getSqlColumnDefinitions() {
        String columnType = this.isDoubleValue ? "DOUBLE" : "BIGINT";
        return new String[]{columnType + " NOT NULL"};
    }

    @Override
    public Object[] toSqlValues(@NotNull Number value) {
        return new Object[]{value};
    }

    @Override
    @NotNull
    public T fromSqlResultSet(@NotNull ResultSet resultSet) throws SQLException {
        Double number = this.isDoubleValue ? resultSet.getDouble(this.valueName) : (double)resultSet.getLong(this.valueName);
        return (T)((Number)this.numberFunction.apply(number));
    }
}

